
-- caseIH160Fl
-- Specialization for caseIH160Fl mod
-- Date 28/11/2014
-- Copyright (C) fozzy691
-- Contact via PM @ romuald.brun691@orange.fr


caseIH160Fl = {};

function caseIH160Fl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function caseIH160Fl:load(xmlFile)
	self.frontLinkageBottomArmRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkageBottomArm#rotationNode"));
	setRotation(self.frontLinkageBottomArmRotNode, math.rad(-92), math.rad(0), math.rad(0)); 
end;

function caseIH160Fl:delete()
end;

function caseIH160Fl:readStream(streamId, connection)
end;

function caseIH160Fl:writeStream(streamId, connection)
end;

function caseIH160Fl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function caseIH160Fl:keyEvent(unicode, sym, modifier, isDown)
end;

function caseIH160Fl:update(dt)
end;

function caseIH160Fl:updateTick(dt)
end;

function caseIH160Fl:draw()
end;

function caseIH160Fl:onLeave()
end;

function caseIH160Fl:onEnter()
end;

function caseIH160Fl:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(0), math.rad(0), math.rad(0)); 
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 3 then
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 4 then
		end;
	end;

	self.updateJoint = true;
end;

function caseIH160Fl:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(-92), math.rad(0), math.rad(0)); 
		end;
	else
	end;
	
	self.updateJoint = true;
end;

function caseIH160Fl:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;
