--BY Dami95 & Mlody & LenoX--

zegary = {};

function zegary.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function zegary:load(xmlFile)
	
--czas - time
	self.czas = {};
	self.czas.index1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#time1"));
	self.czas.index2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#time2"));
	self.czas.light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#time_light"));
end;

function zegary:delete()
end;

function zegary:mouseEvent(posX, posY, isDown, isUp, button)
end;

function zegary:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_f then
		self.podswietlenie = not self.podswietlenie;
	end;
end;

function zegary:update(dt)
	
--czas - time
	local godzinka = tonumber(os.date("%H"));
	if godzinka > 12 then
		godzinka = godzinka - 12;
	end;
	
	local time1_pos = godzinka*-360/12;
	setRotation(self.czas.index1, 0, 0, Utils.degToRad(time1_pos));
	
	local time2_pos = os.date("%M")*-360/60;
	setRotation(self.czas.index2, 0, 0, Utils.degToRad(time2_pos));
	
--podswietlenie - light
	if self.podswietlenie then
		setVisibility(self.speed.light, true);
		setVisibility(self.fuel.light, true);
		setVisibility(self.load.light, true);
		setVisibility(self.rotation.light, true);
		setVisibility(self.czas.light, true);
	else
		setVisibility(self.speed.light, false);
		setVisibility(self.fuel.light, false);
		setVisibility(self.load.light, false);
		setVisibility(self.rotation.light, false);
		setVisibility(self.czas.light, false);
	end;

end;

function zegary:onLeave()
end;

function zegary:draw()
end;