-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

KaercherTurnOnEvent = {};

KaercherTurnOnEvent_mt = Class(KaercherTurnOnEvent, Event);

InitEventClass(KaercherTurnOnEvent, "KaercherTurnOnEvent", EventIds.EVENT_HIGHPRESSURE_WASHER_TURN_ON);

function KaercherTurnOnEvent:emptyNew()
    local self = Event:new(KaercherTurnOnEvent_mt);
    return self;
end;
function KaercherTurnOnEvent:new(object, isTurnedOn, player)
    local self = KaercherTurnOnEvent:emptyNew()
    self.object = object;
    self.isTurnedOn = isTurnedOn;
    self.player = player;
    return self;
end;
function KaercherTurnOnEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.isTurnedOn = streamReadBool(streamId);
    if self.isTurnedOn then
        self.player = networkGetObject(streamReadInt32(streamId));
    end;
    self:run(connection);
end;
function KaercherTurnOnEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.isTurnedOn);
    if self.isTurnedOn then
        streamWriteInt32(streamId, networkGetObjectId(self.player));
    end;
end;
function KaercherTurnOnEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object);
    end;
    self.object:setIsTurnedOn(self.isTurnedOn, self.player, true);
end;
function KaercherTurnOnEvent.sendEvent(object, isTurnedOn, player, noEventSend)
    if isTurnedOn ~= object.isTurnedOn then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(KaercherTurnOnEvent:new(object, isTurnedOn, player), nil, nil, object);
            else
                g_client:getServerConnection():sendEvent(KaercherTurnOnEvent:new(object, isTurnedOn, player));
            end;
        end;
    end;
end;