-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

KaercherStateEvent = {};

KaercherStateEvent_mt = Class(KaercherStateEvent, Event);

InitEventClass(KaercherStateEvent, "KaercherStateEvent", EventIds.EVENT_HIGHPRESSURE_WASHER_STATE);

function KaercherStateEvent:emptyNew()
    local self = Event:new(KaercherStateEvent_mt);
    return self;
end;

function KaercherStateEvent:new(object, doWashing)
    local self = KaercherStateEvent:emptyNew()
    self.object = object;
    self.doWashing = doWashing;
    return self;
end;

function KaercherStateEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.doWashing = streamReadBool(streamId);
    self:run(connection);
end;

function KaercherStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.doWashing);
end;

function KaercherStateEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object);
    end;
    self.object:setIsWashing(self.doWashing, false, true);
end;

function KaercherStateEvent.sendEvent(object, doWashing, noEventSend)
    if doWashing ~= object.doWashing then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(KaercherStateEvent:new(object, doWashing), nil, nil, object);
            else
                g_client:getServerConnection():sendEvent(KaercherStateEvent:new(object, doWashing));
            end;
        end;
    end;
end;