--[[
	Avaible events for buttons
	toggleBeaconLights - OK
	toggleHandBreak - ???
	togglePipe - ???
	toggleFrontLights - OK
	toggleFrontWorkLights - OK
	toggleBackWorkLights - OK
	toggleBeamLights - OK
	toggleTurnsignalLeft - OK
	toggleTurnsignalRight - OK
	toggleTurnsignalHazard - OK
	toggleFoldFrontImplement - OK
	toggleFoldBackImplement - OK
	toggleFrontImplementUpDown - OK
	toggleBackImplementUpDown - OK
	toggleFrontImplementTurnState - OK
	toggleBackImplementTurnState - OK
	dumpEquipment - OK
	dumpBackEquipment - OK
	dumpFrontEquipment - OK
	fillImplement - OK
	fillFrontImplement - OK
	fillBackImplement - OK
	-- new in version 2.34 --
	toggleImplementUpDown - OK
	toggleImplementTurnState - OK
	toggleFoldImplement - OK
	-- new in version 2.42 --
	tempomatUp
	tempomatDown
]]--

function InteractiveControl:actionOnObject(id, isObjectOpen, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(InteractiveControlEvent:new(self, id), nil, nil, self);
		else
			g_client:getServerConnection():sendEvent(InteractiveControlEvent:new(self, id));
		end;
	end;
	
	self:updateOpenStatus(id);
	if self.LIC.interactiveObjects[id].objectType == 0 then
		if self.LIC.interactiveObjects[id].looping then
			if self:getIsAnimationPlaying(self.LIC.interactiveObjects[id].animation) then
				self:stopAnimation(self.LIC.interactiveObjects[id].animation, true);
			else
				self:playAnimation(self.LIC.interactiveObjects[id].animation, dir, Utils.clamp(self:getAnimationTime(self.LIC.interactiveObjects[id].animation), 0, 1), true);
			end;
		else
			local dir = 1;
			local curSpeed = self.animations[self.LIC.interactiveObjects[id].animation].currentSpeed;
			if math.abs(curSpeed) ~= 1 then
				if self:getAnimationTime(self.LIC.interactiveObjects[id].animation) > 0 then
					dir = -1;
				else
					dir = 1;
				end;
			else
				dir = curSpeed*(-1);
			end;
			self:playAnimation(self.LIC.interactiveObjects[id].animation, dir, Utils.clamp(self:getAnimationTime(self.LIC.interactiveObjects[id].animation), 0, 1), true);
		end;
	end;
	if self.LIC.interactiveObjects[id].objectType == 1 then
		if isObjectOpen ~= nil then
			self.LIC.interactiveObjects[id].isOpen = not isObjectOpen;
		end;
		if self.LIC.interactiveObjects[id].event == "toggleBeaconLights" then
			if isObjectOpen ~= nil then
				self:setBeaconLightsVisibility(isObjectOpen);
			else
				if self.beaconLightsActive then
					self:setBeaconLightsVisibility(false);
				else
					self:setBeaconLightsVisibility(true);
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleHandBreak" then
			if self.handbrake then
				self.handbrake = false;
			else
				self.handbrake = true;
			end;
		elseif self.LIC.interactiveObjects[id].event == "togglePipe" then
			local nextState = self.targetPipeState+1;
			if nextState > self.numPipeStates then
				nextState = 1;
			end;
			self:setPipeState(nextState, true);
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontLights" then
			if self.numLightTypes >= 1 then
				local lightsTypesMask = bitXOR(self.lightsTypesMask, 2^0);
				self:setLightsTypesMask(lightsTypesMask, true);
				self.LIC.interactiveObjects[id].isOpen = not self.LIC.interactiveObjects[id].isOpen;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontWorkLights" then
			if self.numLightTypes >= 3 then
				local lightsTypesMask = bitXOR(self.lightsTypesMask, 2^2);
				self:setLightsTypesMask(lightsTypesMask, true);
				self.LIC.interactiveObjects[id].isOpen = not self.LIC.interactiveObjects[id].isOpen;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackWorkLights" then
			if self.numLightTypes >= 2 then
				local lightsTypesMask = bitXOR(self.lightsTypesMask, 2^1);
				self:setLightsTypesMask(lightsTypesMask, true);
				self.LIC.interactiveObjects[id].isOpen = not self.LIC.interactiveObjects[id].isOpen;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBeamLights" then
			if self.numLightTypes >= 4 then
				local lightsTypesMask = bitXOR(self.lightsTypesMask, 2^3);
				self:setLightsTypesMask(lightsTypesMask, true);
				self.LIC.interactiveObjects[id].isOpen = not self.LIC.interactiveObjects[id].isOpen;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalLeft" then
			if self.turnSignalState ~= nil then
				if isObjectOpen ~= nil then
					if not isObjectOpen then
						self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF, false);
					else
						self:setTurnSignalState(Vehicle.TURNSIGNAL_LEFT, false);
					end;
				else
					if self.turnSignalState == Vehicle.TURNSIGNAL_LEFT then
						self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF, false);
					else
						self:setTurnSignalState(Vehicle.TURNSIGNAL_LEFT, false);
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalRight" then
			if self.turnSignalState ~= nil then	
				if isObjectOpen ~= nil then
					if not isObjectOpen then
						self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF, false);
					else
						self:setTurnSignalState(Vehicle.TURNSIGNAL_RIGHT, false);
					end;
				else
					if self.turnSignalState == Vehicle.TURNSIGNAL_RIGHT then
						self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF, false);
					else
						self:setTurnSignalState(Vehicle.TURNSIGNAL_RIGHT, false);
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalHazard" then
			if self.turnSignalState ~= nil then
				if isObjectOpen ~= nil then
					if not isObjectOpen then
						self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF, false);
					else
						self:setTurnSignalState(Vehicle.TURNSIGNAL_HAZARD, false);
					end;
				else
					if self.turnSignalState == Vehicle.TURNSIGNAL_HAZARD then
						self:setTurnSignalState(Vehicle.TURNSIGNAL_OFF, false);
					else
						self:setTurnSignalState(Vehicle.TURNSIGNAL_HAZARD, false);
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "openDisplayLayer" then
			-- something magical happens here
			for _,v1 in pairs(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes) do
				setVisibility(v1, false);
				setTranslation(v1, unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerBackupPos));
			end;
			if not self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].moveDef then
				setVisibility(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].defaultLayer)], true);
				setTranslation(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].defaultLayer)], unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerVisPos));
			end;
			setVisibility(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[id].index)], true);
			setTranslation(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[id].index)], unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerVisPos));
		elseif self.LIC.interactiveObjects[id].event == "closeDisplayLayer" then
			-- and here
			for _,v1 in pairs(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes) do
				setVisibility(v1, false);
				setTranslation(v1, unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerBackupPos));
			end;
			setVisibility(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].defaultLayer)], true);
			setTranslation(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerIndexes[(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].defaultLayer)], unpack(self.LIC.interactiveObjects[(self.LIC.interactiveObjects[id].parentLayer)].layerVisPos));
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldFrontImplement" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil and object.getIsFoldAllowed ~= nil then
							if object:getIsFoldAllowed() then
								if object:getToggledFoldDirection() == object.turnOnFoldDirection then
									object:setFoldState(object:getToggledFoldDirection(), true);
								else
									object:setFoldState(object:getToggledFoldDirection(), false);
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldBackImplement" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil and object.getIsFoldAllowed ~= nil then
							if object:getIsFoldAllowed() then
								if object:getToggledFoldDirection() == object.turnOnFoldDirection then
									object:setFoldState(object:getToggledFoldDirection(), true);
								else
									object:setFoldState(object:getToggledFoldDirection(), false);
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFoldImplement" then
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil and implement.object.getIsFoldAllowed ~= nil then
						if implement.object:getIsFoldAllowed() then
							if implement.object:getToggledFoldDirection() == implement.object.turnOnFoldDirection then
								implement.object:setFoldState(implement.object:getToggledFoldDirection(), true);
							else
								implement.object:setFoldState(implement.object:getToggledFoldDirection(), false);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontImplementUpDown" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered~= nil and object.setPickupState~= nil then
								object.setPickupState(object, not object.isPickupLowered);
							else
								local moveDown = not object:isLowered();	
								if object.getToggledFoldMiddleDirection~= nil then
									local direction = object.getToggledFoldMiddleDirection(object);		
								end;
								self.lowerImplementByJointIndex(self, index, moveDown);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackImplementUpDown" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered~= nil and object.setPickupState~= nil then
								object.setPickupState(object, not object.isPickupLowered);
							else
								local moveDown = not object:isLowered();	
								if object.getToggledFoldMiddleDirection~= nil then
									local direction = object.getToggledFoldMiddleDirection(object);		
								end;
								self.lowerImplementByJointIndex(self, index, moveDown);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleImplementUpDown" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered~= nil and object.setPickupState~= nil then
								object.setPickupState(object, not object.isPickupLowered);
							else
								local moveDown = not object:isLowered();	
								if object.getToggledFoldMiddleDirection~= nil then
									local direction = object.getToggledFoldMiddleDirection(object);		
								end;
								self.lowerImplementByJointIndex(self, index, moveDown);
							end;
						end;
					end;
				end;
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.isPickupLowered~= nil and object.setPickupState~= nil then
								object.setPickupState(object, not object.isPickupLowered);
							else
								local moveDown = not object:isLowered();	
								if object.getToggledFoldMiddleDirection~= nil then
									local direction = object.getToggledFoldMiddleDirection(object);		
								end;
								self.lowerImplementByJointIndex(self, index, moveDown);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontImplementTurnState" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn~= nil and object.isTurnedOn~= nil then
								object:setIsTurnedOn(not object.isTurnedOn);
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn~= nil and self.isTurnedOn~= nil then
									self:setIsTurnedOn(not self.isTurnedOn)
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackImplementTurnState" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								object:setIsTurnedOn(not object.isTurnedOn);
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn~= nil and self.isTurnedOn~= nil then
									self:setIsTurnedOn(not self.isTurnedOn);
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleImplementTurnState" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								object:setIsTurnedOn(not object.isTurnedOn);
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn~= nil and self.isTurnedOn~= nil then
									self:setIsTurnedOn(not self.isTurnedOn);
								end;
							end;
						end;
					end;
				end;
				for _, index in pairs(self.LIC.joints.front) do
					local jointDesc = self.attacherJoints[index];
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						local object = implement.object;
						if object ~= nil then
							if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
								object:setIsTurnedOn(not object.isTurnedOn);
							elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
								if self.setIsTurnedOn~= nil and self.isTurnedOn~= nil then
									self:setIsTurnedOn(not self.isTurnedOn);
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpEquipment" then
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil then
						if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
							if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
									implement.object:toggleTipState(g_currentMission.trailerTipTriggers[implement.object][1], 1, true);
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpBackEquipment" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
									if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
										implement.object:toggleTipState(g_currentMission.trailerTipTriggers[implement.object][1], 1, true);
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "dumpFrontEquipment" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.toggleTipState ~= nil and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and g_currentMission.trailerTipTriggers ~= nil then
								if g_currentMission.trailerTipTriggers[implement.object] ~= nil then
									if g_currentMission.trailerTipTriggers[implement.object][1] ~= nil then
										implement.object:toggleTipState(g_currentMission.trailerTipTriggers[implement.object][1], 1, true);
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillImplement" then
			if self:getIsActive() then
				for _, implement in pairs(self.attachedImplements) do
					if implement.object ~= nil then
						if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
							implement.object:setIsFilling(not implement.object.isFilling);
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillFrontImplement" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.front) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
								implement.object:setIsFilling(not implement.object.isFilling);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "fillBackImplement" then
			if self:getIsActive() then
				for _, index in pairs(self.LIC.joints.back) do
					local implementIndex = self:getImplementIndexByJointDescIndex(index);
					local implement = self.attachedImplements[implementIndex];
					if implement ~= nil then
						if implement.object ~= nil then
							if implement.object.isFilling ~= nil and implement.object.setIsFilling ~= nil then
								implement.object:setIsFilling(not implement.object.isFilling);
							end;
						end;
					end;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "tempomatUp" then
			self:setCruiseControlMaxSpeed(self.cruiseControl.speed + 1);
			if self.cruiseControl.speed ~= self.cruiseControl.speedSent then
				if g_server ~= nil then
					g_server:broadcastEvent(SetCruiseControlSpeedEvent:new(self, self.cruiseControl.speed), nil, nil, self);
				else
					g_client:getServerConnection():sendEvent(SetCruiseControlSpeedEvent:new(self, self.cruiseControl.speed));
				end;
				self.cruiseControl.speedSent = self.cruiseControl.speed;
			end;
		elseif self.LIC.interactiveObjects[id].event == "tempomatDown" then
			self:setCruiseControlMaxSpeed(self.cruiseControl.speed - 1);
			if self.cruiseControl.speed ~= self.cruiseControl.speedSent then
				if g_server ~= nil then
					g_server:broadcastEvent(SetCruiseControlSpeedEvent:new(self, self.cruiseControl.speed), nil, nil, self);
				else
					g_client:getServerConnection():sendEvent(SetCruiseControlSpeedEvent:new(self, self.cruiseControl.speed));
				end;
				self.cruiseControl.speedSent = self.cruiseControl.speed;
			end;
		end;
	end;
	if self.LIC.interactiveObjects[id].objectType == 2 then
		if self:getIsActive() or isObjectOpen ~= nil then
			if isObjectOpen ~= nil then
				self.LIC.interactiveObjects[id].isOpen = not isObjectOpen;
			end;
			local dir = 1;
			if not self.LIC.interactiveObjects[id].isOpen then
				dir = -1;
			end;
			if self.LIC.interactiveObjects[id].startAnimation ~= nil then
				self:playAnimation(self.LIC.interactiveObjects[id].startAnimation, dir, Utils.clamp(self:getAnimationTime(self.LIC.interactiveObjects[id].startAnimation), 0, 1), true);
			end;
			if self.LIC.interactiveObjects[id].isOpen then
				-- neg - so this is closed
				for _,v in pairs(self.LIC.interactiveObjects[id].layerIndexes) do
					setTranslation(v, unpack(self.LIC.interactiveObjects[id].layerBackupPos));
					setVisibility(v, false);
				end;
			else
				for _,v in pairs(self.LIC.interactiveObjects[id].layerIndexes) do
					setTranslation(v, unpack(self.LIC.interactiveObjects[id].layerBackupPos));
					setVisibility(v, false);
				end;
				setTranslation(self.LIC.interactiveObjects[id].layerIndexes[(self.LIC.interactiveObjects[id].defaultLayer)], unpack(self.LIC.interactiveObjects[id].layerVisPos));
				setVisibility(self.LIC.interactiveObjects[id].layerIndexes[(self.LIC.interactiveObjects[id].defaultLayer)], true);
			end;
			self.LIC.interactiveObjects[id].isOpen = not self.LIC.interactiveObjects[id].isOpen;
		end;
	end;
	if self.LIC.interactiveObjects[id].objectType == 3 then
		if self.LIC.interactiveObjects[id].typeChange == "set" then
			if self.LIC.interactiveObjects[id].controlObject ~= nil then
				local vis = not getVisibility(self.LIC.interactiveObjects[id].controlObject);
				for _,v2 in ipairs(self.LIC.interactiveObjects[id].objects) do
					setVisibility(v2, vis);
				end;
			end;
		elseif self.LIC.interactiveObjects[id].typeChange == "toggle" then
			for _,v2 in ipairs(self.LIC.interactiveObjects[id].objects) do
				setVisibility(v2, not getVisibility(v2));
			end;
		else
			print("Invalid toggle type in Interactive Visibility obejct!")
		end;
		self.LIC.interactiveObjects[id].startAction = false;
	end;
	if self.LIC.interactiveObjects[id].objectType == 4 then
		local open = nil;
		if self.LIC.interactiveObjects[id].controlElement ~= nil then
			open = self.LIC.interactiveObjects[self.LIC.interactiveObjects[id].controlElement].isOpen;
		end;
		for _,v in pairs(self.LIC.interactiveObjects[id].actionElements) do
			self:actionOnObject(v, open);
		end;
	end;
	if self.LIC.interactiveObjects[id].objectType == 1 and isObjectOpen ~= nil then
		if self.LIC.interactiveObjects[id].event == "toggleFrontLights" or self.LIC.interactiveObjects[id].event == "toggleFrontWorkLights" or self.LIC.interactiveObjects[id].event == "toggleBackWorkLights" or self.LIC.interactiveObjects[id].event == "toggleBeamLights" then
			self:setLightsTypesMask(0, true);
		end;
	end;
	
	if self.LIC.interactiveObjects[id].audio ~= nil then
		if self:getIsActiveForSound() then
			playSample(self.LIC.interactiveObjects[id].audio,1,1,0);
		end;
	end;
end;

function InteractiveControl:updateOpenStatus(id)
	-- predvypocet jestli mam aktivovan objekt
	if self.LIC.interactiveObjects[id].objectType == 1 then
		if self.LIC.interactiveObjects[id].event == "toggleBeaconLights" then
			self.LIC.interactiveObjects[id].isOpen = not self.beaconLightsActive;
		elseif self.LIC.interactiveObjects[id].event == "toggleHandBreak" then
			self.LIC.interactiveObjects[id].isOpen = not self.handbrake;
		elseif self.LIC.interactiveObjects[id].event == "togglePipe" then
			self.LIC.interactiveObjects[id].isOpen = self.targetPipeState ~= 1;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalLeft" then
			if self.turnSignalState ~= nil then
				if self.turnSignalState == Vehicle.TURNSIGNAL_LEFT then
					self.LIC.interactiveObjects[id].isOpen = false;
				else
					self.LIC.interactiveObjects[id].isOpen = true;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalRight" then
			if self.turnSignalState ~= nil then
				if self.turnSignalState == Vehicle.TURNSIGNAL_RIGHT then
					self.LIC.interactiveObjects[id].isOpen = false;
				else
					self.LIC.interactiveObjects[id].isOpen = true;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleTurnsignalHazard" then
			if self.turnSignalState ~= nil then
				if self.turnSignalState == Vehicle.TURNSIGNAL_HAZARD then
					self.LIC.interactiveObjects[id].isOpen = false;
				else
					self.LIC.interactiveObjects[id].isOpen = true;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleBackImplementTurnState" then
			local youShallNotPass = false;
			for _, index in pairs(self.LIC.joints.back) do
				local jointDesc = self.attacherJoints[index];
				local implementIndex = self:getImplementIndexByJointDescIndex(index);
				local implement = self.attachedImplements[implementIndex];
				if implement ~= nil then
					local object = implement.object;
					if object ~= nil then
						if object.setIsTurnedOn ~= nil and object.isTurnedOn ~= nil then
							self.LIC.interactiveObjects[id].isOpen = object.isTurnedOn;
							youShallNotPass = true;
						elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
							if self.setIsTurnedOn ~= nil and self.isTurnedOn ~= nil then
								self.LIC.interactiveObjects[id].isOpen = self.isTurnedOn;
								youShallNotPass = true;
							end;
						end;
					end;
				end;
				if youShallNotPass then
					break;
				end;
			end;
		elseif self.LIC.interactiveObjects[id].event == "toggleFrontImplementTurnState" then
			local youShallNotPass = false;
			for _, index in pairs(self.LIC.joints.front) do
				local jointDesc = self.attacherJoints[index];
				local implementIndex = self:getImplementIndexByJointDescIndex(index);
				local implement = self.attachedImplements[implementIndex];
				if implement ~= nil then
					local object = implement.object;
					if object ~= nil then
						if object.setIsTurnedOn~= nil and object.isTurnedOn~= nil then
							self.LIC.interactiveObjects[id].isOpen = object.isTurnedOn;
							youShallNotPass = true;
						elseif jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER or jointDesc.jointType == Vehicle.JOINTTYPE_CUTTERHARVESTER then	
							if self.setIsTurnedOn~= nil and self.isTurnedOn~= nil then
								self.LIC.interactiveObjects[id].isOpen = self.isTurnedOn;
								youShallNotPass = true;
							end;
						end;
					end;
				end;
				if youShallNotPass then
					break;
				end;
			end;
		end;
	elseif self.LIC.interactiveObjects[id].objectType == 4 then
		if self.LIC.interactiveObjects[id].controlElement ~= nil then
			self:updateOpenStatus(self.LIC.interactiveObjects[id].controlElement);
		end;
	end;
end;