--
-- objectAttacher
-- Specialization for attaching objects on a trailer
--
-- @author Geri-G
--
-- edited by PeterJ FS-UK modteam
-- 16/11/2012
--

objectAttacher = {};

function objectAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function objectAttacher:load(xmlFile)

	self.setIsBaleAttached = SpecializationUtil.callSpecializationsFunction("setIsBaleAttached");
	self.searchObjects = objectAttacher.searchObjects;
	self.attachobjects = objectAttacher.attachobjects;
	self.detachobjects = objectAttacher.detachobjects;
	self.OrientJoint = objectAttacher.OrientJoint;
	self.isObjectInRange = objectAttacher.isObjectInRange;
	self.place = {};
	local i=0;
	while true do
		local basename = string.format("vehicle.baleCastPoints.baleCastPoint(%d)",i);
		local place = {};
		place.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#frontRight"));

		if place.node1 == nil then
			break;
		end;
		place.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,basename.."#backLeft"));
		place.attacherNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,basename.."#attacherNode"),"0>"));
		place.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,basename.."#highOffset"),4);
		table.insert(self.place,place);
		i=i+1;
	end;
	self.allowVehicleAttachment = getXMLBool(xmlFile,"vehicle.baleCastPoints#allowVehicleAttachment");
	self.Attachedobjects = {};
	self.objectsAttached = false;
	self.isBaleAttach = false;
	
	
	self.allowLockByKey = getXMLBool(xmlFile,"vehicle.baleCastPoints#controlledByKey");
	if self.allowLockByKey == nil then
		self.allowLockByKey = true;
	else
		self.handlerArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.movingTools.movingTool#index"));
		self.handlerArmMax = math.rad(getXMLFloat(xmlFile, "vehicle.baleCastPoints#unlockRot"));
		self.handlerArmMin = math.rad(getXMLFloat(xmlFile, "vehicle.baleCastPoints#lockRot"));
	end;
    for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
    end;
end;

function objectAttacher:delete()
end;