Mchale998StateEvent = {}
Mchale998StateEvent_mt = Class(Mchale998StateEvent, Event)
InitEventClass(Mchale998StateEvent, "Mchale998StateEvent")
function Mchale998StateEvent:emptyNew()
  local self = Event:new(Mchale998StateEvent_mt)
  return self
end
function Mchale998StateEvent:new(object, stateId, nearestBaleServerId)
  local self = Mchale998StateEvent:emptyNew()
  self.object = object
  self.stateId = stateId
  assert(nearestBaleServerId ~= nil or self.stateId ~= Mchale998.CHANGE_GRAB_BALE)
  self.nearestBaleServerId = nearestBaleServerId
  return self
end
function Mchale998StateEvent:readStream(streamId, connection)
  self.object = networkGetObject(streamReadInt32(streamId))
  self.stateId = streamReadInt8(streamId)
  if self.stateId == Mchale998.CHANGE_GRAB_BALE then
    self.nearestBaleServerId = streamReadInt32(streamId)
  end
  self:run(connection)
end
function Mchale998StateEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, networkGetObjectId(self.object))
  streamWriteInt8(streamId, self.stateId)
  if self.stateId == Mchale998.CHANGE_GRAB_BALE then
    streamWriteInt32(streamId, self.nearestBaleServerId)
  end
end
function Mchale998StateEvent:run(connection)
  self.object:doStateChange(self.stateId, self.nearestBaleServerId)
end
