RotationNodes = {}

function RotationNodes.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Combine, specializations)
end
function RotationNodes:load(xmlFile)
	self.ProtationNodes = {}
	local i = 0
	while true do
		local key = string.format("vehicle.ProtationNodes.rotationNode(%d)", i)
		if not hasXMLProperty(xmlFile, key) then
			break
		end
		local Pnode = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"))
		local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key .. "#rotSpeed"), 1) * 0.001)
		if Pnode ~= nil then
			table.insert(self.ProtationNodes, {Pnode = Pnode, rotSpeed = rotSpeed, rotation = 0})
		end
		i = i + 1
	end
	self.WrotationNodes = {}
	local i = 0
	while true do
		local key = string.format("vehicle.WrotationNodes.rotationNode(%d)", i)
		if not hasXMLProperty(xmlFile, key) then
			break
		end
		local Wnode = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"))
		local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key .. "#rotSpeed"), 1) * 0.001)
		if Wnode ~= nil then
			table.insert(self.WrotationNodes, {Wnode = Wnode, rotSpeed = rotSpeed, rotation = 0})
		end
		i = i + 1
	end	
end

function RotationNodes:delete()
end

function RotationNodes:mouseEvent(posX, posY, isDown, isUp, button)
end

function RotationNodes:keyEvent(unicode, sym, modifier, isDown)
end

function RotationNodes:update(dt)
end

function RotationNodes:updateTick(dt)
	if self:getIsActive() and self.isMotorStarted then
		for _, Pnode in pairs(self.ProtationNodes) do
			Pnode.rotation = (Pnode.rotation + dt * Pnode.rotSpeed) % (2 * math.pi)
			setRotation(Pnode.Pnode, Pnode.rotation, 0, 0)  --- (Wnode.Wnode, , Y, Z)     
		end		
	    if self.isThreshing then
			for _, Wnode in pairs(self.WrotationNodes) do
				Wnode.rotation = (Wnode.rotation + dt * Wnode.rotSpeed) % (2 * math.pi)
				setRotation(Wnode.Wnode, Wnode.rotation, 0, 0)  ---    (Wnode.Wnode, , Y, Z)      (  Y -- setRotation(Wnode.Wnode, 0, Wnode.rotation, 0)
			end	
		end
	end	

    if self.isClient then
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
end

function RotationNodes:draw()
end
