--
-- custom for marstonAce16Trailer
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v0.1
-- @date:       2013-11-22
-- 


marstonAce = {};

function marstonAce.prerequisitesPresent(specializations)
    return true;
end;

function marstonAce:load(xmlFile)
	self.setSheet = SpecializationUtil.callSpecializationsFunction("setSheet");
	self.setBodyType = Utils.prependedFunction(self.setBodyType, changeBodyTypes.setBodyType);
	
	self.sheet = {};
	self.sheet.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sheet#node"));
	self.sheet.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sheet#node2"));
	self.sheet.isActive = false;
	
end;

function marstonAce:delete()
end;

function marstonAce:readStream(streamId, connection)
	self:setSheet(streamReadBool(streamId), true);
end;

function marstonAce:writeStream(streamId, connection)
	streamWriteBool(streamId, self.sheet.isActive);
end;

function marstonAce:mouseEvent(posX, posY, isDown, isUp, button)
end;

function marstonAce:keyEvent(unicode, sym, modifier, isDown)
end;

function marstonAce:update(dt)
	if self:getIsActive() then
		if self.lastBodyType == 1 then
			if InputBinding.hasEvent(InputBinding.TOGGLE_SHEET) then
				self:setSheet(not self.sheet.isActive);
			end;
		end;
	end;
end;

function marstonAce:updateTick(dt)
end;

function marstonAce:draw()
	if self.lastBodyType == 1 then
		if self.sheet.isActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("UNSHEET"), InputBinding.TOGGLE_SHEET);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("SHEETOVER"), InputBinding.TOGGLE_SHEET);
		end;
	end;
end;

function marstonAce:setSheet(state, noEventSend)
	self.sheet.isActive = state;
	setVisibility(self.sheet.node, state);
	if self.lastBodyType ~= 1 then
		setVisibility(self.sheet.node2, state);
	else
		setVisibility(self.sheet.node2, not state);
	end;
	
	setSheetEvent.sendEvent(self, state, noEventSend)
end;

function marstonAce:setBodyType(bodyId, forceFillLevel)
	if bodyId ~= 1 then
		self:setSheet(false);
	end;
end;


-- Event --
setSheetEvent = {};
setSheetEvent_mt = Class(setSheetEvent, Event);
  
InitEventClass(setSheetEvent, "setSheetEvent");
  
function setSheetEvent:emptyNew()
	local self = Event:new(setSheetEvent_mt);
	self.className = "setSheetEvent";
	
	return self;
end;
  
function setSheetEvent:new(object, sheet)
	local self = setSheetEvent:emptyNew()
	self.object = object;
	self.sheet = sheet;
	
	return self;
end;
  
function setSheetEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.sheet = streamReadBool(streamId);
	self.object = networkGetObject(id);
	
	self:run(connection);
end;
  
function setSheetEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.sheet);
end;
  
function setSheetEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	
	self.object:setSheet(self.sheet, true);
end;
  
function setSheetEvent.sendEvent(vehicle, sheet, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setSheetEvent:new(vehicle, sheet), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setSheetEvent:new(vehicle, sheet));
		end;
	end;
end;