﻿sprayeraddon = {};
local modName = g_currentModName;
local modDir = g_currentModDirectory;
function sprayeraddon.prerequisitesPresent(specializations)
	return true;
end;

function sprayeraddon:load(xmlFile)
    self.addReFillTrigger = sprayeraddon.addReFillTrigger;
    self.setIsReFilling = sprayeraddon.setIsReFilling;
    self.removeReFillTrigger = sprayeraddon.removeReFillTrigger;
    self.isReFilling = false;
    self.ReFillTriggers = {};
	self.ReFillTrigger = nil
end;

function sprayeraddon:delete()
end;
function sprayeraddon:mouseEvent(posX, posY, isDown, isUp, button)
end;
function sprayeraddon:keyEvent(unicode, sym, modifier, isDown)
end;

function sprayeraddon:update(dt)
	if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
		 self:setIsReFilling(not self.isReFilling)
	end
	self.ReFillTrigger = nil;
	for i=1, table.getn(self.ReFillTriggers) do
		local trigger = self.ReFillTriggers[i];
		if trigger:getIsActivatable2(self.sprayeraddon) then
			self.ReFillTrigger = trigger;
		end;
	end;
end

function sprayeraddon:readStream(streamId, connection)
    local isReFilling = streamReadBool(streamId);
    local ReFillTrigger = nil
    if isReFilling then
        ReFillTrigger = networkGetObject(streamReadInt32(streamId));
    end;
    self:setIsReFilling(isReFilling, ReFillTrigger, true);
end;

function sprayeraddon:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isReFilling);
    if self.isReFilling then
        streamWriteInt32(streamId, networkGetObjectId(self.ReFillTrigger));
    end;
end;




function sprayeraddon:updateTick(dt)
	if self.isSprayerFilling and self.isReFilling then
		self:setIsSprayerFilling(false);
	end
	if self.isReFilling and self.ReFillTrigger ~= nil and self.isServer then
		local disableFilling = false;
		if self.ReFillTrigger:allowFillType(self.currentFillType, false) then
            local oldFillLevel = self.fillLevel;
            local delta = 300*dt*0.001;
            self.ReFillTrigger:DoReFill(self, delta);
            local delta = oldFillLevel - self.fillLevel ;
            if delta <= 0 then
                disableFilling = true;
            end;
        else
            disableFilling = true;
        end;
		if disableFilling then
			self:setIsReFilling(false);
		end;
    end;
end;

function sprayeraddon:draw()
	if self.ReFillTrigger ~= nil then
		if self.isReFilling then
			g_currentMission:addExtraPrintText("Taste y um befüllung abzubrrechen"); 
		else
			g_currentMission:addExtraPrintText("Taste y um Zwichenlager zu befüllen"); 
		end
	end
end;

function sprayeraddon:setIsReFilling(isFilling, fillTrigger, noEventSend)
    if self.isServer and self.issprayerFilling then
        self:setIsSprayerFilling(false);
    end;
    sprayeraddonsetIsReFillingEvent.sendEvent(self, isFilling, self.ReFillTrigger, noEventSend)
    if self.isReFilling ~= isFilling then
        self.isReFilling = isFilling;
    end;
end;

function sprayeraddon:setIsSprayerFilling(isFilling, fillType, isSiloTrigger, noEventSend)
    if self.isServer and self.isReFilling then
        self:setIsReFilling(false);
    end;
end;

function sprayeraddon:addReFillTrigger(trigger)
    table.insert(self.ReFillTriggers, trigger);
end;

function sprayeraddon:removeReFillTrigger(trigger)
    for i=1, table.getn(self.ReFillTriggers) do
        if self.ReFillTriggers[i] == trigger then
            table.remove(self.ReFillTriggers, i);
            break;
        end;
    end;
	 if table.getn(self.ReFillTriggers) == 0 or trigger == self.ReFillTrigger then
        if self.isServer then
            self.isReFilling = false;
        end;
    end;
end;
----------------------------------------------------------------------------------------------------------------------------

 sprayeraddonsetIsReFillingEvent = {};
 sprayeraddonsetIsReFillingEvent_mt = Class( sprayeraddonsetIsReFillingEvent, Event);

InitEventClass( sprayeraddonsetIsReFillingEvent, " sprayeraddonsetIsReFillingEvent");

function  sprayeraddonsetIsReFillingEvent:emptyNew()
    local self = Event:new( sprayeraddonsetIsReFillingEvent_mt);
    self.className=modName..". sprayeraddonsetIsReFillingEvent";
    return self;
end;

function  sprayeraddonsetIsReFillingEvent:new(object, isFilling, trigger)
    local self =  sprayeraddonsetIsReFillingEvent:emptyNew()
    self.object = object;
    self.isReFilling = isFilling;
    self.ReFillTrigger = trigger;
    return self;
end;

function  sprayeraddonsetIsReFillingEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.isReFilling = streamReadBool(streamId);
    if self.isReFilling and not connection:getIsServer() then
        self.ReFillTrigger = networkGetObject(streamReadInt32(streamId));
    end;
    self:run(connection);
end;

function  sprayeraddonsetIsReFillingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.isReFilling);
    if self.isReFilling and connection:getIsServer() then
        streamWriteInt32(streamId, networkGetObjectId(self.ReFillTrigger));
    end;
end;

function  sprayeraddonsetIsReFillingEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object);
    end;
    self.object:setIsReFilling(self.isReFilling, self.ReFillTrigger, true);
end;

function  sprayeraddonsetIsReFillingEvent.sendEvent(object, isFilling, trigger, noEventSend)
    if isFilling ~= object.isReFilling then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent( sprayeraddonsetIsReFillingEvent:new(object, isFilling, trigger), nil, nil, object);
            else
                assert(not isFilling or (trigger ~= nil));
                g_client:getServerConnection():sendEvent( sprayeraddonsetIsReFillingEvent:new(object, isFilling, trigger));
            end;
        end;
    end;
end;
