-- by mor2000
-- >99% copied out of SiloTrigger.lua and TipTrigger.lua

-- low tech silo storage for several storages

-- only for bullgores MIG Map

SiloTrigger2 = {}
local SiloTrigger2_mt = Class(SiloTrigger2, SiloTrigger)
InitObjectClass(SiloTrigger2, "SiloTrigger2")

SiloTrigger2.originalToDummy={}
SiloTrigger2.originalToDummy["wheat"]="wheat2"
SiloTrigger2.originalToDummy["barley"]="barley2"
SiloTrigger2.originalToDummy["maize"]="maize2"
SiloTrigger2.originalToDummy["rape"]="rape2"
SiloTrigger2.originalToDummy["sunflower"]="sunflower2"
SiloTrigger2.originalToDummy["hemp"]="hemp2"
SiloTrigger2.originalToDummy["oat"]="oat2"
SiloTrigger2.originalToDummy["rye"]="rye2"

for _,v in pairs(SiloTrigger2.originalToDummy) do
	Fillable.registerFillType(v, nil, nil, true, nil) -- nil ok?
	--if g_currentMission.farmSiloAmounts[Fillable.fillTypeNameToInt[v]]==nil
end

function SiloTrigger2.onCreate(id)
	local trigger = SiloTrigger2:new(g_server ~= nil, g_client ~= nil)
	local index = g_currentMission:addOnCreateLoadedObject(trigger)
	trigger:load(id)
	trigger:register(true)
end
function SiloTrigger2:new(isServer, isClient)
	local self = SiloTrigger:new(isServer, isClient, SiloTrigger2_mt)
	self.rootNode = 0
	self.siloTriggerDirtyFlag = self:getNextDirtyFlag()
	self.update=SiloTrigger2.update
	return self
end
function SiloTrigger2:update(dt)
	if self.isServer then
		local trailer = self.siloTrailer
		if self.fill >= 4 and trailer ~= nil and not self.fillDone then
			trailer:resetFillLevelIfNeeded(self.fillType)
			local fillLevel = trailer:getFillLevel(self.fillType)
			fillType = Fillable.fillTypeNameToInt[SiloTrigger2.originalToDummy[Fillable.fillTypeIntToName[self.fillType]]]
			local siloAmount = g_currentMission:getSiloAmount(fillType)
			if siloAmount > 0 and trailer:allowFillType(self.fillType, false) then
				do
					local deltaFillLevel = math.min(self.fillLitersPerSecond * 0.001 * dt, siloAmount)
					trailer:setFillLevel(fillLevel + deltaFillLevel, self.fillType)
					local newFillLevel = trailer:getFillLevel(self.fillType)
					if fillLevel ~= newFillLevel then
						g_currentMission:setSiloAmount(fillType, math.max(siloAmount - (newFillLevel - fillLevel), 0))
						self:startFill()
					else
						self.fillDone = true
						self:stopFill()
					end
				end
			else
				self.fillDone = true
				self:stopFill()
			end
		end
	end
end

-- use <Attribute name="onCreate" type="scriptCallback" value="modOnCreate.SiloTrigger2"/>
g_onCreateUtil.addOnCreateFunction("SiloTrigger2", SiloTrigger2.onCreate)

SiloTrigger3 = {}
local SiloTrigger3_mt = Class(SiloTrigger3, SiloTrigger)
InitObjectClass(SiloTrigger3, "SiloTrigger3")

SiloTrigger3.originalToDummy={}
SiloTrigger3.originalToDummy["wheat"]="wheat3"
SiloTrigger3.originalToDummy["barley"]="barley3"
SiloTrigger3.originalToDummy["maize"]="maize3"
SiloTrigger3.originalToDummy["rape"]="rape3"
SiloTrigger3.originalToDummy["sunflower"]="sunflower3"
SiloTrigger3.originalToDummy["hemp"]="hemp3"
SiloTrigger3.originalToDummy["oat"]="oat3"
SiloTrigger3.originalToDummy["rye"]="rye3"

for _,v in pairs(SiloTrigger3.originalToDummy) do
	Fillable.registerFillType(v, nil, nil, true, nil) -- nil ok?
end

function SiloTrigger3.onCreate(id)
	local trigger = SiloTrigger3:new(g_server ~= nil, g_client ~= nil)
	local index = g_currentMission:addOnCreateLoadedObject(trigger)
	trigger:load(id)
	trigger:register(true)
end
function SiloTrigger3:new(isServer, isClient)
	local self = SiloTrigger:new(isServer, isClient, SiloTrigger3_mt)
	self.rootNode = 0
	self.siloTriggerDirtyFlag = self:getNextDirtyFlag()
	self.update=SiloTrigger3.update
	return self
end
function SiloTrigger3:update(dt)
	if self.isServer then
		local trailer = self.siloTrailer
		if self.fill >= 4 and trailer ~= nil and not self.fillDone then
			trailer:resetFillLevelIfNeeded(self.fillType)
			local fillLevel = trailer:getFillLevel(self.fillType)
			fillType = Fillable.fillTypeNameToInt[SiloTrigger3.originalToDummy[Fillable.fillTypeIntToName[self.fillType]]]
			local siloAmount = g_currentMission:getSiloAmount(fillType)
			if siloAmount > 0 and trailer:allowFillType(self.fillType, false) then
				do
					local deltaFillLevel = math.min(self.fillLitersPerSecond * 0.001 * dt, siloAmount)
					trailer:setFillLevel(fillLevel + deltaFillLevel, self.fillType)
					local newFillLevel = trailer:getFillLevel(self.fillType)
					if fillLevel ~= newFillLevel then
						g_currentMission:setSiloAmount(fillType, math.max(siloAmount - (newFillLevel - fillLevel), 0))
						self:startFill()
					else
						self.fillDone = true
						self:stopFill()
					end
				end
			else
				self.fillDone = true
				self:stopFill()
			end
		end
	end
end

-- use <Attribute name="onCreate" type="scriptCallback" value="modOnCreate.SiloTrigger3"/>
g_onCreateUtil.addOnCreateFunction("SiloTrigger3", SiloTrigger3.onCreate)

TipTrigger2 = {}
local TipTrigger2_mt = Class(TipTrigger2, TipTrigger)
InitObjectClass(TipTrigger2, "TipTrigger2")

function TipTrigger2.onCreate(id)
	local trigger = TipTrigger2:new(g_server ~= nil, g_client ~= nil)
	local index = g_currentMission:addOnCreateLoadedObject(trigger)
	trigger:load(id)
	trigger:register(true)
end
function TipTrigger2:new(isServer, isClient, customMt)
	if customMt == nil then
		customMt = TipTrigger2_mt
	end
	local self = TipTrigger:new(isServer, isClient, customMt)
	self.updateTrailerTipping=TipTrigger2.updateTrailerTipping
	self.triggerId = 0
	self.rootNode = 0
	g_currentMission:addTipTrigger(self)
	return self
end
function TipTrigger2:updateTrailerTipping(trailer, fillDelta, fillType)
	if fillDelta < 0 then
		if self.isFarmTrigger then
			do
				local siloFillType = fillType
				if fillType == Fillable.FILLTYPE_DRYGRASS then
					siloFillType = Fillable.FILLTYPE_GRASS
				end
				fillType = Fillable.fillTypeNameToInt[SiloTrigger2.originalToDummy[Fillable.fillTypeIntToName[siloFillType]]]
				g_currentMission:setSiloAmount(fillType, g_currentMission:getSiloAmount(fillType) - fillDelta)
			end
		else
			local desc = Fillable.fillTypeIndexToDesc[fillType]
			desc.totalAmount = desc.totalAmount - fillDelta
			local priceMultiplier = self.priceMultipliers[fillType]
			local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1)
			local greatDemandMultiplier = 1
			local greatDemand = g_currentMission.economyManager:getCurrentGreatDemand(self.stationName, fillType)
			if greatDemand ~= nil then
				greatDemandMultiplier = greatDemand.demandMultiplier
			end
			local money = Fillable.fillTypeIndexToDesc[fillType].pricePerLiter * priceMultiplier * difficultyMultiplier * greatDemandMultiplier * -fillDelta
			g_currentMission:addSharedMoney(money, "harvestIncome")
		end
		self:updateMoving(-fillDelta)
	end
end

-- use <Attribute name="onCreate" type="scriptCallback" value="modOnCreate.TipTrigger2"/>
g_onCreateUtil.addOnCreateFunction("TipTrigger2", TipTrigger2.onCreate)

TipTrigger3 = {}
local TipTrigger3_mt = Class(TipTrigger3, TipTrigger)
InitObjectClass(TipTrigger3, "TipTrigger3")

function TipTrigger3.onCreate(id)
	local trigger = TipTrigger3:new(g_server ~= nil, g_client ~= nil)
	local index = g_currentMission:addOnCreateLoadedObject(trigger)
	trigger:load(id)
	trigger:register(true)
end
function TipTrigger3:new(isServer, isClient, customMt)
	if customMt == nil then
		customMt = TipTrigger3_mt
	end
	local self = TipTrigger:new(isServer, isClient, customMt)
	self.updateTrailerTipping=TipTrigger3.updateTrailerTipping
	self.triggerId = 0
	self.rootNode = 0
	g_currentMission:addTipTrigger(self)
	return self
end
function TipTrigger3:updateTrailerTipping(trailer, fillDelta, fillType)
	if fillDelta < 0 then
		if self.isFarmTrigger then
			do
				local siloFillType = fillType
				if fillType == Fillable.FILLTYPE_DRYGRASS then
					siloFillType = Fillable.FILLTYPE_GRASS
				end
				fillType = Fillable.fillTypeNameToInt[SiloTrigger3.originalToDummy[Fillable.fillTypeIntToName[siloFillType]]]
				g_currentMission:setSiloAmount(fillType, g_currentMission:getSiloAmount(fillType) - fillDelta)
			end
		else
			local desc = Fillable.fillTypeIndexToDesc[fillType]
			desc.totalAmount = desc.totalAmount - fillDelta
			local priceMultiplier = self.priceMultipliers[fillType]
			local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1)
			local greatDemandMultiplier = 1
			local greatDemand = g_currentMission.economyManager:getCurrentGreatDemand(self.stationName, fillType)
			if greatDemand ~= nil then
				greatDemandMultiplier = greatDemand.demandMultiplier
			end
			local money = Fillable.fillTypeIndexToDesc[fillType].pricePerLiter * priceMultiplier * difficultyMultiplier * greatDemandMultiplier * -fillDelta
			g_currentMission:addSharedMoney(money, "harvestIncome")
		end
		self:updateMoving(-fillDelta)
	end
end

-- use <Attribute name="onCreate" type="scriptCallback" value="modOnCreate.TipTrigger3"/>
g_onCreateUtil.addOnCreateFunction("TipTrigger3", TipTrigger3.onCreate)





MehrereHoefePDA = {}

function MehrereHoefePDA:loadMap(name)
	self.migloaded=false
	if name==g_modsDirectory.."/MIG_Map_MadeInGermany_Celle/map01.i3d" then
		self.migloaded=true
		self.typeName="MehrereHoefePDA";
		g_currentMission.missionPDA:addStatsPage(self.drawStatsPage2, self, self.typeName)
		g_currentMission.missionPDA:addStatsPage(self.drawStatsPage3, self, self.typeName)
	end
end

function MehrereHoefePDA:delete()
end

function MehrereHoefePDA:mouseEvent(posX, posY, isDown, isUp, button)
end

function MehrereHoefePDA:keyEvent(unicode, sym, modifier, isDown)
end

function MehrereHoefePDA:update(dt)
end

function MehrereHoefePDA:drawStatsPage2()
    setTextBold(true)
    setTextColor(1, 1, 1, 1)
    setTextBold(false)
 
    local yOffset = 0.025
    local fluid_unit_short=g_i18n:getText("fluid_unit_short")
    local pda = g_currentMission.missionPDA

	local j=2

	setTextBold(true)
	renderText(pda.pdaCol1, pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize, g_i18n:getText("hof4"))
	setTextBold(false)

	for k,v in pairs(SiloTrigger2.originalToDummy) do
		j=j+1
		fillType=Fillable.fillTypeNameToInt[k]
		fillLevel=g_currentMission:getSiloAmount(Fillable.fillTypeNameToInt[v])
		renderText(pda.pdaCol1, pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize,
  	  			g_i18n:getText(k) .. " [" .. fluid_unit_short .. "] ")
		renderText(pda.pdaCol2,	pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize,
				tostring(math.floor(fillLevel)))
	end
	
	setTextColor(1, 1, 1, 1)
end

function MehrereHoefePDA:drawStatsPage3()
    setTextBold(true)
    setTextColor(1, 1, 1, 1)
    setTextBold(false)
 
    local yOffset = 0.025
    local fluid_unit_short=g_i18n:getText("fluid_unit_short")
    local pda = g_currentMission.missionPDA

	local j=2

	setTextBold(true)
	renderText(pda.pdaCol1, pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize, g_i18n:getText("hof5"))
	setTextBold(false)
	
	for k,v in pairs(SiloTrigger3.originalToDummy) do
		j=j+1
		fillType=Fillable.fillTypeNameToInt[k]
		fillLevel=g_currentMission:getSiloAmount(Fillable.fillTypeNameToInt[v])
		renderText(pda.pdaCol1, pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize,
  	  			g_i18n:getText(k) .. " [" .. fluid_unit_short .. "] ")
		renderText(pda.pdaCol2,	pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize,
				tostring(math.floor(fillLevel)))
	end
	
	setTextColor(1, 1, 1, 1)
end

function MehrereHoefePDA:draw()
end;

function MehrereHoefePDA:deleteMap()
	if self.migloaded then
		g_currentMission.missionPDA:removeStatsPage(self.drawStatsPage2, self, self.typeName)
		g_currentMission.missionPDA:removeStatsPage(self.drawStatsPage3, self, self.typeName)
	end
end

addModEventListener(MehrereHoefePDA)
