--
-- add specialization to all mods.
--
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2012-11-11
-- @history:    v1.0 - inital implementation
--

addSpecialization = {};
addSpecialization.isLoaded = true;
addSpecialization.g_currentModDirectory = g_currentModDirectory;

if SpecializationUtil.specializations["sprayeraddon"] == nil then
	SpecializationUtil.registerSpecialization("sprayeraddon", "sprayeraddon", g_currentModDirectory .. "map01/spec/sprayeraddon.lua")
	addSpecialization.isLoaded = false;
-- else
	-- print("  manualIgnition have been loaded already!");
end;

addModEventListener(addSpecialization);

function addSpecialization:loadMap(name)	
    if not addSpecialization.isLoaded then
		addSpecialization:add();
        addSpecialization.isLoaded = true;
    end;
end;

function addSpecialization:deleteMap()
    addSpecialization.isLoaded = false;
end;

function addSpecialization:mouseEvent(posX, posY, isDown, isUp, button)
end;

function addSpecialization:keyEvent(unicode, sym, modifier, isDown)
end;

function addSpecialization:update(dt)
end;

function addSpecialization:draw()
end;

function addSpecialization:add()
	local searchTable = {
		"sprayeraddon",
		};
	
	for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
		local modName = string.match(k, "([^.]+)");
		
		local addSpecialization = true;
		for _, search in pairs(searchTable) do
			if SpecializationUtil.specializations[modName .. "." .. search] ~= nil then
				addSpecialization = false;
				break;
			end;
		end;
		
		if SpecializationUtil.hasSpecialization(sprayeraddon, v.specializations) then
			addSpecialization = false;
			break;
		end;
		
		local correctLocation = false;
		for i = 1, table.maxn(v.specializations) do
			local vs = v.specializations[i];
			if vs ~= nil and vs == SpecializationUtil.getSpecialization("fillable") then
				correctLocation = true;
				break;
			end;
		end;
		if addSpecialization and correctLocation then
			table.insert(v.specializations, SpecializationUtil.getSpecialization("sprayeraddon"));
			print("  sprayeraddon was inserted on " .. k);
		elseif correctLocation and not addSpecialization then
			print("  Failed to inserting sprayeraddon on " .. k);
		end;
	end;
end;