-- by "Marhu" 
-- v 1.0
-- Date: 10.05.2013
--"Register Fill Types only for loaded Map"

RegFillTypes = {};
RegFillTypes.dir = g_currentModDirectory
RegFillTypes.t = {};

--[[Fillable.registerFillType "fill"
--  name						name			string
--  nameI18N					I18N			string --in modDesc.xml der Map eingeben <l10n>
--  pricePerLiter,				price			float
--  partOfEconomy				Eco				bool
--  hudOverlayFilename			hud				string
]]

local HudDir = "huds/"		--"map/Hud/"

table.insert(RegFillTypes.t, { name="pig", price=0.1, Eco=true, hud=HudDir.."pigHUD"});
table.insert(RegFillTypes.t, { name="beef", price=0.1, Eco=true, hud=HudDir.."beefHUD"});

local org_FSBaseMission_loadMap = FSBaseMission.loadMap
FSBaseMission.loadMap = function(a, b, c, d, e)
	if a.baseDirectory == RegFillTypes.dir then
		RegFillTypes.MapName = a.missionInfo.map.title;
		local fill={}
		for i=1, table.getn(RegFillTypes.t) do
			local t = RegFillTypes.t[i];
			local HudFile = RegFillTypes.dir..t.hud..".dds";
			local I18N = t.I18N
			if I18N == nil then
				if g_i18n:hasText(t.name) then
					I18N = g_i18n:getText(t.name);
				else
					I18N = t.name;
				end;
			end;
			local FillType = Fillable.registerFillType(t.name,I18N,t.price,t.Eco,HudFile);
			if Fillable.fillTypeIndexToDesc[FillType] and Fillable.fillTypeIndexToDesc[FillType].nameI18N then
				FSBaseMission.addFillTypeOverlay(a,FillType,HudFile)
				--print("  Register fill type: ",Fillable.fillTypeIndexToDesc[FillType].nameI18N);
				table.insert(fill,Fillable.fillTypeIndexToDesc[FillType].nameI18N);
			else
				--print("  Register fill type: ",t.name," not nameI18N");
				table.insert(fill,t.name.." not nameI18N");
			end;
		end;

		local types = RegFillTypes.MapName..": Register Fill type: ";
		for k, v in pairs(fill) do
			types = types..v..", ";
		end;
		print(types)
	end;		
	ra,rb,rc,rd,re = org_FSBaseMission_loadMap(a, b, c, d, e)
	return ra,rb,rc,rd,re 
end





-------------------------------------------------------------------------------------------------------------------------------------





WaterBand = {};

local WaterBand_mt = Class(WaterBand);

print("Load Script: WaterBand = OK");

function WaterBand.onCreate(id)
	g_currentMission:addUpdateable(WaterBand:new(id));
	--print("created WaterBand, id: ", id);
end;

function WaterBand:new(id, customMt)
  
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, WaterBand_mt);
	end;
		
	local fruitType = getUserAttribute(id, "fruitType");
    if fruitType ~= nil then
		local trigger = SiloTrigger:new(g_server ~= nil, g_client ~= nil);
		local index = g_currentMission:addOnCreateLoadedObject(trigger);
		trigger:load(id);
		trigger:register(true);
		local desc = FruitUtil.fruitTypes[fruitType];
        if desc ~= nil then
			instance.Band = trigger
		elseif Fillable.fillTypeNameToInt[fruitType] then
			trigger.fillType = Fillable.fillTypeNameToInt[fruitType]
			instance.Band = trigger
			if trigger.fillType == Fillable.FILLTYPE_MANURE then
				instance.isCowManure = Utils.getNoNil(getUserAttribute(id, "CowManure"), false);
				if instance.isCowManure then
					instance.Ori_update = instance.Band.update
					function instance.Band:update(dt)
					end;
				end
			end
			if trigger.fillType == Fillable.FILLTYPE_BARLEY_WINDROW or trigger.fillType == Fillable.FILLTYPE_WHEAT_WINDROW then
				--trigger.fillType = function() if g_currentMission:getSiloAmount(Fillable.FILLTYPE_BARLEY_WINDROW) > 0 then return Fillable.FILLTYPE_BARLEY_WINDROW else return Fillable.FILLTYPE_WHEAT_WINDROW end end;
				instance.Stroh = true
			end
		end
		
		instance.IsNotSilo = Utils.getNoNil(getUserAttribute(id, "IsNotSilo"), false);
		if instance.IsNotSilo then
			instance.Ori_update = instance.Band.update
			function instance.Band:update(dt) end;
		end
		
		instance.plane = Utils.indexToObject(id, getUserAttribute(id, "PlaneIndex"));
        if instance.plane ~= nil then
            instance.planeShaderParameterName =  "scrollSpeed";
            local planeScrollSpeed = getUserAttribute(instance.plane, "scrollSpeed");
            if planeScrollSpeed ~= nil then
                instance.planeSpeedX, instance.planeSpeedY = Utils.getVectorFromString(planeScrollSpeed);
            end
            if instance.planeSpeedX == nil then
                instance.planeSpeedX = 0;
            end
            if instance.planeSpeedY == nil then
                instance.planeSpeedY = -0.75;
            end
			setVisibility(instance.plane, false);
            setShaderParameter(instance.plane, instance.planeShaderParameterName, 0, 0, 0, 0, false);
        end
	end
   
    return instance;
end;
  
function WaterBand:delete()
end;
  
function WaterBand:update(dt)
  
	if g_currentMission:getIsClient() then
		if self.Band.isFilling then
			if self.plane and not self.setShader then
				self.setShader = true
				setVisibility(self.plane, true);
				setShaderParameter(self.plane, self.planeShaderParameterName, self.planeSpeedX, self.planeSpeedY, 0, 0, false);
			end
		elseif self.plane and self.setShader then
			self.setShader = nil
			setVisibility(self.plane, false);
			setShaderParameter(self.plane, self.planeShaderParameterName, 0, 0, 0, 0, false);
		end
	end
	
	if self.isCowManure or self.IsNotSilo then	
		if g_currentMission:getIsServer()  then
			local trailer = self.Band.siloTrailer;
			if self.Band.fill >= 4 and trailer ~= nil and not self.Band.fillDone then
				trailer:resetFillLevelIfNeeded(self.Band.fillType);
				local fillLevel = trailer:getFillLevel(self.Band.fillType);
				if self.isCowManure then
					local siloAmount = g_currentMission.husbandries.cow.manureHeap.fillLevel;
					if siloAmount > 0 and trailer:allowFillType(self.Band.fillType, false) then
						local deltaFillLevel = math.min(self.Band.fillLitersPerSecond*0.001*dt, siloAmount);
						trailer:setFillLevel(fillLevel+deltaFillLevel, self.Band.fillType);
						local newFillLevel = trailer:getFillLevel(self.Band.fillType);
	  
						if fillLevel ~= newFillLevel then
							local setFillLvl = math.max(siloAmount-(newFillLevel-fillLevel), 0);
							local object = g_currentMission:getNodeObject(g_currentMission.husbandries.cow.manureHeap.triggerId);
							object:setFillLevel(setFillLvl);
							self.Band:startFill();
						else
							self.Band.fillDone = true; -- trailer is full
							self.Band:stopFill();
						end;
	  
					else
						self.Band.fillDone = true; -- silo is empty or trailer does not support fill type
						self.Band:stopFill();
					end;
				elseif self.IsNotSilo then
					if trailer:allowFillType(self.Band.fillType, false) then
						local deltaFillLevel = self.Band.fillLitersPerSecond*0.001*dt;
						trailer:setFillLevel(fillLevel+deltaFillLevel, self.Band.fillType);
						local newFillLevel = trailer:getFillLevel(self.Band.fillType);

						if fillLevel ~= newFillLevel then
							local delta = math.max((newFillLevel-fillLevel), 0);
							local fillTypeDesc = Fillable.fillTypeIndexToDesc[self.Band.fillType]
							if fillTypeDesc ~= nil then
								local price = delta*fillTypeDesc.pricePerLiter * g_currentMission.missionStats.difficulty;
								g_currentMission:addSharedMoney(-price, "other");
							end
							self.Band:startFill();
						else
							self.Band.fillDone = true; -- trailer is full
							self.Band:stopFill();
						end;

					else
						self.Band.fillDone = true; -- trailer does not support fill type
						self.Band:stopFill();
					end;
				end;
			end;
		end;
	end;
	
	if self.Stroh and self.Band.siloTrailer == nil then
		if g_currentMission:getSiloAmount(Fillable.FILLTYPE_BARLEY_WINDROW) > 0 then 
			self.Band.fillType = Fillable.FILLTYPE_BARLEY_WINDROW 
		else
			self.Band.fillType = Fillable.FILLTYPE_WHEAT_WINDROW 
		end;
	end;
end;
   
g_onCreateUtil.addOnCreateFunction("WaterBand", WaterBand.onCreate);