--
-- MIG_Map_MadeInGermany_Celle
--
-- @author  Stefan Geiger
-- @date  12/07/10
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

MIG_Map_MadeInGermany_Celle = {}

local MIG_Map_MadeInGermany_Celle_mt = Class(MIG_Map_MadeInGermany_Celle, Mission00);


function MIG_Map_MadeInGermany_Celle:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = MIG_Map_MadeInGermany_Celle_mt;
    end;
    local self = MIG_Map_MadeInGermany_Celle:superClass():new(baseDirectory, mt);

    return self;
end;

function MIG_Map_MadeInGermany_Celle:delete()
    MIG_Map_MadeInGermany_Celle:superClass().delete(self);
end;

function MIG_Map_MadeInGermany_Celle:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;
		self.AnimationMapConfig = {"map01/spec/AnimationMap.xml", self.baseDirectory};

    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory), true, self.loadCareerMap01Finished, self);
	
	FruitUtil.fruitTypes.sugarBeet.literPerSqm = 7.5;
	FruitUtil.fruitTypes.rape.literPerSqm = 0.816;
	FruitUtil.fruitTypes.maize.literPerSqm = 2.0;
	FruitUtil.fruitTypes.wheat.literPerSqm = 0.85;
	FruitUtil.fruitTypes.barley.literPerSqm = 0.633;
	FruitUtil.fruitTypes.grass.literPerSqm = 3;	
end;

function MIG_Map_MadeInGermany_Celle:loadCareerMap01Finished(node, arguments)
	self.terrainDetailAngleNumChannels = 8; -- durch die gewünschte Anzahl Channels ersetzen
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    if self.cancelLoading then
        return;
    end
    local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("MIG_Map_MadeInGermany_Celle.xml", self.baseDirectory));
    trcScreenFlip();
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
	trcScreenFlip();
    self.ingameMap:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 4096, 4096);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 4096, 4096);

	trcScreenFlip();

    -- Vehicle Shop
    self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), -453, -784, nil, nil, false, false, false, 0, true);

    -- farm silos
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 273, -972, nil, nil, false, false, false, 0, true);
    -- Bga
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 366, 516, nil, nil, false, false, false, 0, true);
    -- Getreide Werner
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -1745, -232, nil, nil, false, false, false, 0, true);
    -- Muehle Saegewerk
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 1286, -1610, nil, nil, false, false, false, 0, true);

    -- livestock
    self.ingameMap:createMapHotspot("Cows", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_cows.png", self.baseDirectory), -565, -677, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Sheep", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_sheep.png", self.baseDirectory), -482, -1001, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Chickens", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_chickens.png", self.baseDirectory), -439, -967, nil, nil, false, false, false, 0, true);

    -- Wolle
    self.ingameMap:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_spinnery.png", self.baseDirectory), 1382, -1581, nil, nil, false, false, false, 0, true);

    -- Guellelager
    self.ingameMap:createMapHotspot("liquidManureGuellelager", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 1308, -1131, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("liquidManureGuellelager", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -972, -1460, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("liquidManureGuellelager", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -410, -147, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("liquidManureGuellelager", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -1246, -494, nil, nil, false, false, false, 0, true);

    self.ingameMap:createMapHotspot("siloFreiland", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -417, -186, nil, nil, false, false, false, 0, true);

    self.ingameMap:createMapHotspot("watercraftWasserwerk", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -429, 17, nil, nil, false, false, false, 0, true);
	

	trcScreenFlip();
    MIG_Map_MadeInGermany_Celle:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
end;

function MIG_Map_MadeInGermany_Celle:onStartMission()
    MIG_Map_MadeInGermany_Celle:superClass().onStartMission(self);
end;

function MIG_Map_MadeInGermany_Celle:mouseEvent(posX, posY, isDown, isUp, button)
    MIG_Map_MadeInGermany_Celle:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function MIG_Map_MadeInGermany_Celle:keyEvent(unicode, sym, modifier, isDown)
    MIG_Map_MadeInGermany_Celle:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function MIG_Map_MadeInGermany_Celle:update(dt)
    MIG_Map_MadeInGermany_Celle:superClass().update(self, dt);
end;

function MIG_Map_MadeInGermany_Celle:draw()
    MIG_Map_MadeInGermany_Celle:superClass().draw(self);
end;
