--
-- nightGrowth
-- 
-- 
--
-- LS13 V0.1: upsideDown 16.02.2014
-- LS15 V1.1: upsidedown 16.11.2014

nightGrowth = {};
addModEventListener(nightGrowth);

function nightGrowth:loadMap(name)
	print("--- loading nightGrowth mod V1.1 --- (by upsidedown)")
	g_currentMission.getFoliageGrowthStateTimeMultiplier = Utils.overwrittenFunction(g_currentMission.getFoliageGrowthStateTimeMultiplier,nightGrowth.getFoliageGrowthStateTimeMultiplier);
	nightGrowth.lastGrowthDay = g_currentMission.environment.currentDay;
	nightGrowth.dayDone = true;
	
	nightGrowth.stopHour = 4; --growth is limited between midnight and 4am (nightGrowth.stopHour = 4);
	nightGrowth.slowDownFactor = 1.0; --3.6;
	
	-- nightGrowth.doGrowthAdjust = true;
	-- nightGrowth.doGrowthAdjustDone = false;
	-- nightGrowth.targetHours = 24; --targetHours = 24; means one growth state every 24 hours (growth set to normal in game menu)
	
	nightGrowth:loadConfigFile();   
	
	nightGrowth.doGrowthAdjustDone = false;
end;

function nightGrowth:deleteMap()
end


function nightGrowth:mouseEvent(posX, posY, isDown, isUp, button)
end;

function nightGrowth:keyEvent(unicode, sym, modifier, isDown)
end;


function nightGrowth:update(dt)
	if nightGrowth.doGrowthAdjust and not nightGrowth.doGrowthAdjustDone then
		if nightGrowth.doGrowthAdjust then
			local mapValue = g_currentMission.fruitsList[1].originalGrowthStateTime;
			mapValue = mapValue/3600000;
			nightGrowth.slowDownFactor = nightGrowth.targetHours/mapValue;
			nightGrowth.doGrowthAdjustDone = true;
		end;	
	end;

	if g_currentMission.environment.currentDay > nightGrowth.lastGrowthDay then
		g_currentMission:updateFoliageGrowthStateTime()
		nightGrowth.lastGrowthDay = g_currentMission.environment.currentDay;
		nightGrowth.dayDone = false;
	end;
	
	if not nightGrowth.dayDone and g_currentMission.environment.dayTime > nightGrowth.stopHour*1000*3600 then	
		g_currentMission:updateFoliageGrowthStateTime();		
		nightGrowth.dayDone = true;
	end;
	
end;


function nightGrowth:draw()   
end;


function nightGrowth:getFoliageGrowthStateTimeMultiplier(superFunc)
	local value = superFunc(self);
	if nightGrowth.doNightGrowth then
		if self.environment.dayTime < nightGrowth.stopHour*1000*3600 then		
			value = value*nightGrowth.slowDownFactor * nightGrowth.stopHour/24;
		else
			value = 3000000; --high value means essentially no growth
		end;
	else
		value = value*nightGrowth.slowDownFactor;
	end;
	return value
end;



function nightGrowth:loadConfigFile()
	local path = getUserProfileAppPath();
	local Xml;
	local file = path.."/nightGrowth_config.xml";
		
	if fileExists(file) then
		print("loading "..file.." for nightGrowth-Mod configuration");
		Xml = loadXMLFile("nightGrowth_XML", file, "nightGrowth");		
	else
		print("creating "..file.." for nightGrowth-Mod configuration");
		Xml = createXMLFile("nightGrowth_XML", file, "nightGrowth");
	end;
	
	local doNightGrowth = getXMLBool(Xml, "nightGrowth.doNightGrowth");
	if doNightGrowth == nil then
		doNightGrowth = true;
		setXMLBool(Xml, "nightGrowth.doNightGrowth",true);
	end;
	
	local doGrowthAdjust = getXMLBool(Xml, "nightGrowth.adjustGrowthTime");
	if doGrowthAdjust == nil then
		doGrowthAdjust = false;
		setXMLBool(Xml, "nightGrowth.adjustGrowthTime",false);
	end;
	
	local growthAdjustHours = getXMLFloat(Xml, "nightGrowth.growthAdjustHours");
	if growthAdjustHours == nil then
		growthAdjustHours = 24;
		setXMLFloat(Xml, "nightGrowth.growthAdjustHours",24);
	end;
	
	nightGrowth.doNightGrowth = doNightGrowth;
	nightGrowth.doGrowthAdjust = doGrowthAdjust;
	
	nightGrowth.targetHours = growthAdjustHours;
	
	if nightGrowth.doNightGrowth then
		print("nightGrowth: growth shifted into night hours")
	end;
	
	if nightGrowth.doGrowthAdjust then
		print(string.format("nightGrowth: normal growthStage time set to %.1f hours",nightGrowth.targetHours))
	end;
	
	
		
	saveXMLFile(Xml);
end;