--
-- add specialization to all mods.
--
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.52
-- @date:       2013-10-29
--

addSpecializationOdometer = {};
addSpecializationOdometer.isLoaded = true;
addSpecializationOdometer.g_currentModDirectory = g_currentModDirectory;

if SpecializationUtil.specializations['Odometer'] == nil then
	SpecializationUtil.registerSpecialization('Odometer', 'Odometer', g_currentModDirectory .. 'Odometer.lua')
	addSpecializationOdometer.isLoaded = false;
end;

addModEventListener(addSpecializationOdometer);

function addSpecializationOdometer:loadMap(name)
	if not addSpecializationOdometer.isLoaded then
		addSpecializationOdometer:add();
		addSpecializationOdometer.isLoaded = true;
	end;
end;

function addSpecializationOdometer:deleteMap()
end;

function addSpecializationOdometer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function addSpecializationOdometer:keyEvent(unicode, sym, modifier, isDown)
end;

function addSpecializationOdometer:update(dt)
end;

function addSpecializationOdometer:draw()
end;

function addSpecializationOdometer:add()
	local searchTable = { 'Odometer', 'odometer' };
	local vehiclesInserted = {};

	for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
		local correctLocation = false;
		for i = 1, table.maxn(v.specializations) do
			local vs = v.specializations[i];

			if vs ~= nil and vs == SpecializationUtil.getSpecialization('drivable') then
				correctLocation = true;
				break;
			end;
		end;

		if correctLocation then
			local addSpecialization;
			local modNameTable = Utils.splitString('.', k);
			local modName = modNameTable[1];
			local spec = {};

			for name, spe in pairs(SpecializationUtil.specializations) do
				if string.find(name, modName) ~= nil then
					local parts = Utils.splitString('.', name);

					if #(parts) > 1 then
						table.insert(spec, parts);
					end;
				end;
			end;

			for _, s in pairs(spec) do
				for _, search in pairs(searchTable) do
					if string.find(string.lower(s[2]), search) ~= nil then
						addSpecialization = s[2];
						break;
					end;
				end;
			end;

			if addSpecialization == nil then
				table.insert(v.specializations, SpecializationUtil.getSpecialization('Odometer'));
				vehiclesInserted[#vehiclesInserted + 1] = k;
			else
				print('Odometer: Failed inserting on ' .. k .. ' as it already has the spec "' .. addSpecialization .. '"');
			end;
		end;
	end;
	if #vehiclesInserted > 0 then
		print('Odometer inserted in:\n\t' .. table.concat(vehiclesInserted, '\n\t'));
	end;
end;