--[[
@title:		Odometer
@authors:	unknown (original spec), Jakob Tischler
@version:	1.2
@date:		
@history:	v1.0: 					original release spec
			v1.1:					* make specialization global
									* fix distance ratio for regular and 4x maps
									* add gui for Giants' "newGUI" (patch 2.0 and higher)
			v1.11 (10 May 2014):	* fix multiple savegame loading/deleting error
			v1.2  (28 Nov 2014):	* adapt to FS15, new hud, use Courseplay API function
]]

Odometer = {
	modDir = g_currentModDirectory;
};

function Odometer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

local function pxToNormal(dimension, n, halfSize)
	local ret = n / 1080;
	if dimension == 'x' then
		ret = ret / g_screenAspectRatio
	end;
	if halfSize then
		return ret * 0.5;
	end;

	return ret;
end;

function Odometer:load(xmlFile)
	self.Odometer = {};

	self.Odometer.current = 0;
	self.Odometer.total = 0;

	self.Odometer.width = pxToNormal('x', 512, true);
	self.Odometer.height = pxToNormal('y', 64, true);
	self.Odometer.posX = Utils.getNoNil(getXMLFloat(xmlFile, 'vehicle.odometer#posX'), pxToNormal('x', 1587)); -- 0.5
	self.Odometer.posY = Utils.getNoNil(getXMLFloat(xmlFile, 'vehicle.odometer#posY'), pxToNormal('y',  194)); -- 1 - self.Odometer.height * 1.25
	self.Odometer.hud = Overlay:new('OdometerOverlay', Utils.getFilename('odometerHud.png', Odometer.modDir), self.Odometer.posX, self.Odometer.posY, self.Odometer.width, self.Odometer.height);

	self.Odometer.textCurrentPosX = self.Odometer.posX + pxToNormal('x', 182, true);
	self.Odometer.textTotalPosX = self.Odometer.posX + pxToNormal('x', 486, true);
	self.Odometer.textPosY = self.Odometer.posY + pxToNormal('y', 18, true);
	self.Odometer.fontSize = pxToNormal('y', 36, true);
end;

function Odometer:delete()
	self.Odometer.current = 0;
	if self.Odometer.hud then
		self.Odometer.hud:delete();
		self.Odometer.hud = nil;
	end;
end;

function Odometer:readStream(streamId, connection)
	self.Odometer.current = streamReadFloat32(streamId);
	self.Odometer.total = streamReadFloat32(streamId);
end;

function Odometer:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.Odometer.current);
	streamWriteFloat32(streamId, self.Odometer.total);
end;

function Odometer:mouseEvent(posX, posY, isDown, isUp, button) end;
function Odometer:keyEvent(unicode, sym, modifier, isDown) end;

function Odometer:update(dt)
	if self:getIsActive() or self.isHired or self.drive or (self.getIsCourseplayDriving and self:getIsCourseplayDriving()) then
		self.Odometer.current = self.Odometer.current + self.lastMovedDistance;
		self.Odometer.total = self.Odometer.total + self.lastMovedDistance;
	end;
end;

function Odometer:updateTick(dt) end;

function Odometer:draw()
	self.Odometer.hud:render();

	local current = ('%.1f'):format(g_i18n:getDistance(self.Odometer.current * 0.001));
	local total = ('%.1f'):format(g_i18n:getDistance(self.Odometer.total * 0.001));

	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(false);
	setTextColor(1,1,1, 1);

	renderText(self.Odometer.textCurrentPosX, self.Odometer.textPosY, self.Odometer.fontSize, current);
	renderText(self.Odometer.textTotalPosX, self.Odometer.textPosY, self.Odometer.fontSize, total);

	-- reset
	setTextAlignment(RenderText.ALIGN_LEFT);
end;

function Odometer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.Odometer.total = getXMLFloat(xmlFile, key .. '#odometer') or self.Odometer.total;
	end;

	return BaseMission.VEHICLE_LOAD_OK;
end;

function Odometer:getSaveAttributesAndNodes(nodeIdent)
	return ('odometer=%q'):format(tostring(self.Odometer.total)), nil;
end;