--
-- randomEconomics
-- 
-- 
--
-- upsideDown 02.02.2014

randomEconomics = {};
addModEventListener(randomEconomics);

function randomEconomics:loadMap(name)
	if RealisticGlobalListener == nil then
		g_currentMission.onDayChanged = Utils.overwrittenFunction(g_currentMission.onDayChanged,randomEconomics.onDayChanged);
		randomEconomics.active = true;
		randomEconomics.timer = 8000;
	else
		print("randomEconomics:: found MR by dural --> not active")
		randomEconomics.active = false;
	end;
	
	-- local dir = g_currentMission.missionInfo.savegameDirectory;
	-- if dir~=nil then
		-- local filePath = dir .. '/randomEconomics.xml';
		-- local file;
		-- if not fileExists(filePath) then
			-- file = createXMLFile('randomEconomicsFile', filePath, 'XML');			
		-- else
			-- file = loadXMLFile('randomEconomicsFile', filePath);			
		-- end;
		
		
		
	-- end;
end;

function randomEconomics:deleteMap()
end


function randomEconomics:mouseEvent(posX, posY, isDown, isUp, button)
end;

function randomEconomics:keyEvent(unicode, sym, modifier, isDown)
end;


function randomEconomics:update(dt)
	if g_currentMission:getIsServer() then 
		if randomEconomics.active then
			if randomEconomics.timer < 0 then		
				
				for k,object in pairs(g_currentMission.tipTriggers) do
					if object.priceMultipliers ~= nil then
						if table.getn(object.priceMultipliers) > 0 then
							g_server:broadcastEvent(randomEconomicsEvent:new(object));
						end;
					end;
				end;
				randomEconomics.timer = 5000 + 3000*math.random();
				
			else
				randomEconomics.timer = randomEconomics.timer - dt;
			end;
		end;		
	end;
end


function randomEconomics:draw()
   
   
end;

function randomEconomics:onDayChanged(superFunc)
   superFunc(self)
   
    if self:getIsServer() then 
		
		for k,object in pairs(g_currentMission.tipTriggers) do
			if object.priceMultipliers ~= nil then
				if table.getn(object.priceMultipliers) > 0 then
					if object.randomEconomicsBaseValues == nil then
						object.randomEconomicsBaseValues = {};
						for kk,pM in pairs(object.priceMultipliers) do
							object.randomEconomicsBaseValues[kk] = pM;
						end;
						
						object.randomEconomicsMultipliers = {};
						for kk,pM in pairs(object.priceMultipliers) do
							object.randomEconomicsMultipliers[kk] = 1;
						end;
					end;
	 
					for kk,pM in pairs(object.priceMultipliers) do
						local shift = 0.25*(math.random()-0.5);
						object.randomEconomicsMultipliers[kk] = object.randomEconomicsMultipliers[kk] + shift;
						object.randomEconomicsMultipliers[kk] = Utils.clamp(object.randomEconomicsMultipliers[kk],0.5,1.5);
						object.priceMultipliers[kk] = object.randomEconomicsBaseValues[kk]*object.randomEconomicsMultipliers[kk];
					end;
				
					g_server:broadcastEvent(randomEconomicsEvent:new(object));
				end;
			end;			
		end;
    end;
end;




randomEconomicsEvent = {};
  randomEconomicsEvent_mt = Class(randomEconomicsEvent, Event);
  
  InitEventClass(randomEconomicsEvent, "randomEconomicsEvent");
  
  function randomEconomicsEvent:emptyNew()
      local self = Event:new(randomEconomicsEvent_mt);
      return self;
  end;
  
  function randomEconomicsEvent:new(object)
      local self = randomEconomicsEvent:emptyNew()
      
	  
      self.object = object;
	  local i=0;
	  self.indizes = {};
	  self.multipliers = {};
	  for kk,pM in pairs(object.priceMultipliers) do
		i = i+1;
		self.indizes[i] = kk;
		self.multipliers[i] = pM;		
	  end;
	  
	  self.Nvalues = i;
	  
      return self;
  end;
  
  function randomEconomicsEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.Nvalues);
	if self.Nvalues > 0 then
		for i=1,self.Nvalues do
			streamWriteInt32(streamId,self.indizes[i])
			streamWriteFloat32(streamId,self.multipliers[i]);		
		end;
	end;
	
	 
	 
  end;
  
function randomEconomicsEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);

	local Nvalues = streamReadInt32(streamId);

	if Nvalues > 0 then
		for i=1,Nvalues do
			local index = streamReadInt32(streamId);			
			self.object.priceMultipliers[index] = streamReadFloat32(streamId);
		end;
	end;      
end;
  
  
  
  function randomEconomicsEvent:run(connection)
	  print("Error: do not run randomEconomicsEvent locally!")
  end;