SpecializationUtil.registerSpecialization("multiSpray", "multiSpray", g_currentModDirectory.."multiSpray.lua")

multiSpray_Register = {};

function multiSpray_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		print("--- loading multiSprayer mod V2.1 --- (by upsidedown)")
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("sprayer") then 
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.multiSpray", _name)) ~= nil then
								allowInsertion = false;								
							end;							
						end;
						if allowInsertion then
							table.insert(v.specializations, SpecializationUtil.getSpecialization("multiSpray"));
							vs.multiSpray_TXT_HERB = g_i18n:getText("multiSpray_TXT_HERB");
							vs.multiSpray_TXT_FERT = g_i18n:getText("multiSpray_TXT_FERT");
							vs.multiSpray_TXT_FERTSPR = g_i18n:getText("multiSpray_TXT_FERTSPR");
							vs.multiSpray_TXT_SOW = g_i18n:getText("multiSpray_TXT_SOW");
							vs.multiSpray_TXT_SEED = g_i18n:getText("multiSpray_TXT_SEED");								
						end;						
					end;
				end;
			end;	
		end;
	end;
	
	
	
end;

function multiSpray_Register:deleteMap()
  
end;

function multiSpray_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function multiSpray_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function multiSpray_Register:update(dt)
	
end;

function multiSpray_Register:draw()
  
end;

addModEventListener(multiSpray_Register);