--herbicide.lua
--
-- upsidedown
-- V1.0 initial version for MIG
-- V2.0 public release of mod for all maps. changelog see multispray.lua

-- register new fruittype "weed"
if FruitUtil.FRUITTYPE_WEED ~= nil then --Weed is registered here and NOwhere else! (including old map-script version)
	FruitUtil.FRUITTYPE_WEED = nil;
	
	for k,listener in pairs(g_modEventListeners) do --hunter&killer for old map script in MIG V0.88 / V0.88_1
		if listener.newUpdateCultivatorArea ~= nil then
			table.remove(g_modEventListeners,k);
			print("obsolete herbicide.lua from map removed!")
			break;
		end;
	end;
	
end;
FruitUtil.registerFruitType("weed", "weed18n", false, false, false, 0, 4, 7, 1,false, 0.005, 0, 0, false,"",nil);
print("register fruitType: weed (multiSpray/herbicide mod by upsidedown)");

herbicide = {};


addModEventListener(herbicide);

function herbicide:loadMap(name)
	if herbicide.sprayerUpdateTick == nil then --change functions only once:
		print("loading multiSpray/herbicide Mod V2.1 (by upsidedown)")
		
		herbicide.sprayerUpdateTick = Sprayer.updateTick;
		Sprayer.updateTick = herbicide.newSprayerUpdateTick;
		
		herbicide.updateCultivatorArea = Utils.updateCultivatorArea;
		Utils.updateCultivatorArea = herbicide.newUpdateCultivatorArea;
		
		herbicide.updatePloughArea = Utils.updatePloughArea;
		Utils.updatePloughArea = herbicide.newUpdatePloughArea;
		
		herbicide.cutFruitArea = Utils.cutFruitArea;
		Utils.cutFruitArea = herbicide.newCutFruitArea;
		
		herbicide.updateSowingArea = Utils.updateSowingArea;
		Utils.updateSowingArea = herbicide.newUpdateSowingArea;


		herbicide.updateFruitPreparerArea = Utils.updateFruitPreparerArea;
		Utils.updateFruitPreparerArea = herbicide.newUpdateFruitPreparerArea;
		
	end;
	
	--this we make new for every map:
	herbicide.xVec = {};
	herbicide.zVec = {};
	herbicide.mapInitDone = false;
	herbicide.maxN = 0;
	herbicide.xCnt = 0;
	herbicide.zCnt = 1;
	
	herbicide.stepSize = 25; -- edge length of scanning box
	
	herbicide.timeCnt = 0;
end;

function herbicide:deleteMap()
end


function herbicide:mouseEvent(posX, posY, isDown, isUp, button)
end;

function herbicide:keyEvent(unicode, sym, modifier, isDown)
end;


function herbicide:update(dt)	

	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		if not herbicide.mapInitDone then
			if true then --init terrain scanner
				local tSize = g_currentMission.terrainSize;		
				
				local stepSize = herbicide.stepSize;
				local cnt = 1;
				for value=-tSize*0.5,tSize*0.5,stepSize do
					herbicide.xVec[cnt] = value;
					herbicide.zVec[cnt] = value;
					cnt = cnt+1;
				end;
				herbicide.maxN = cnt-1;	
			end;
			
			if false then --adjust originalGrowthStateTime for weed based on wheat (...)
				local tuningFactor = 1.0; --for later fineTuning;
				local diffFactors = {1.0,0.85,0.45};
				local newTime = tuningFactor*diffFactors[g_currentMission.missionStats.difficulty]*g_currentMission.fruits[FruitUtil.FRUITTYPE_WHEAT].originalGrowthStateTime;
				--newTime = math.max(newTime,
				g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].originalGrowthStateTime = newTime;
				print("weed growthTime set to: "..tostring(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].originalGrowthStateTime))
				
				--for ref: wheat on std-map: 24000000.000000 (4h ingame time)				
				
				g_currentMission:updateFoliageGrowthStateTime();				
			end;
			
			g_currentMission.hasHerbicide = true;
			herbicide.mapInitDone = true;
		end;
		
		herbicide.timeCnt = herbicide.timeCnt + dt;
		
		herbicide.xCnt = herbicide.xCnt + 1;
		if herbicide.xCnt > herbicide.maxN then
			herbicide.xCnt = 1;
			herbicide.zCnt = herbicide.zCnt + 1;
			if herbicide.zCnt > herbicide.maxN then
				herbicide.zCnt = 1;
			end;
			if false then --debug print after each full row:
				print("mapScan ETC: ",herbicide.timeCnt*0.001*herbicide.maxN/60," Minuten: ",herbicide.zCnt/herbicide.maxN*100," Prozent")
			end;
			herbicide.timeCnt = 0;			
		end;
		
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil and not g_currentMission.hasGrowthManager then
			local startWorldX = herbicide.xVec[herbicide.xCnt];
			local startWorldZ = herbicide.zVec[herbicide.zCnt];
			local widthWorldX = startWorldX + herbicide.stepSize;
			local widthWorldZ = startWorldZ;
			local heightWorldX = startWorldX;
			local heightWorldZ = startWorldZ + herbicide.stepSize;
			
			local id = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id;
			local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_WEED];
			local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
			
			
					
			setDensityReturnValueShift(id, -1);			
			for index,fruit in pairs(g_currentMission.fruits) do
				if index ~= FruitUtil.FRUITTYPE_WEED and fruit.id > 0 then
					--local excludeMask=0;
					local desc = FruitUtil.fruitIndexToDesc[index];
					
					
					-- kill weed if fruit is grown to at least minHarvestingGrowthState-1 and weed is not larger than 2nd growth state
					if true then
						--desc.minPreparingGrowthState
					    --desc.maxPreparingGrowthState
						local minState = desc.minHarvestingGrowthState;
						local maxState = desc.maxHarvestingGrowthState+1;
						if desc.minPreparingGrowthState > 0 then -- potatoes, sugarBeet
							minState = desc.minPreparingGrowthState;
							maxState = desc.maxPreparingGrowthState + 1;
						end;
					
						setDensityMaskParams(id, "between", minState, maxState); 				
						setDensityCompareParams(id, "between", 4, 5);
						setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, fruit.id, 0, g_currentMission.numFruitStateChannels, 1)
						setDensityCompareParams(id, "greater", -1);
						setDensityMaskParams(id, "greater", 0);
					end;
					
					--kill fruit if weed is too high and fruit is too small
					if true then
						setDensityMaskParams(fruit.id, "between", 6, 7);
						setDensityCompareParams(fruit.id, "between", 1, 2);
						setDensityMaskedParallelogram(fruit.id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, id, 0, g_currentMission.numFruitStateChannels, 0)
						setDensityCompareParams(fruit.id, "greater", -1);
						setDensityMaskParams(fruit.id, "greater", 0);
					end;
					
					
				end;			
			end;
			
			if true then --weed is using up the fertilizer
				local detailId = g_currentMission.terrainDetailId;
				setDensityMaskParams(detailId, "between", 6, 7);
				setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, id, 0, g_currentMission.numFruitStateChannels, 0);
				setDensityMaskParams(detailId, "greater", 0);
			end;
			
			
			if true then-- destroy out of field completely
				local excludeMask = 2^g_currentMission.sowingChannel + 2^g_currentMission.sowingWidthChannel + 2^g_currentMission.cultivatorChannel + 2^g_currentMission.ploughChannel;
				local detailId = g_currentMission.terrainDetailId;
				 
				setDensityMaskParams(id, "greater", -1, 0, 0, excludeMask);
				
				setDensityCompareParams(id, "greater", -1);
				
				setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitDensityMapChannels, detailId, g_currentMission.terrainDetailTypeFirstChannel, 		g_currentMission.terrainDetailTypeNumChannels, 0);
											
				setDensityCompareParams(id, "greater", -1);
				setDensityMaskParams(id, "greater", 0);

			end;-- end destroy out of field
			
			
			setDensityReturnValueShift(id, 0);
			
		
		end;
		
	end;
end


function herbicide:draw()   
end;



function herbicide.newUpdateCultivatorArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle)
	
		
	if false and g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then --check if ploughed AND thistle is already growing but not fully grown
		local id = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id;
		local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_WEED];
		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	
		local detailId = g_currentMission.terrainDetailId;
		
		setDensityReturnValueShift(id, -1);
        setDensityCompareParams(id, "between", 5, 7);
       -- setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 10);
		setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, detailId, g_currentMission.ploughChannel, 1, 9)
		
		setDensityCompareParams(id, "greater", -1);
		setDensityReturnValueShift(id, 0);
	end;
	
	
	local area = herbicide.updateCultivatorArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle);
	
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		local detailId = g_currentMission.terrainDetailId;
		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(detailId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
		
		local id = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id;
		setDensityReturnValueShift(id, -1);
		--setDensityParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0)
		setDensityCompareParams(id, "between", -1, 8);
		setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, detailId, g_currentMission.cultivatorChannel, 1, 3)
		setDensityCompareParams(id, "greater", -1);
		setDensityReturnValueShift(id, 0);
		
		--setDensityReturnValueShift(id, -1);
		----setDensityParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0)
		-- setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, detailId, g_currentMission.cultivatorChannel, 1, 3)
		-- setDensityReturnValueShift(id, 0);
		
	end;
	return area;
end;



function herbicide.newUpdatePloughArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle)
	
	if true and g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then --check if cultivated AND thistle is already growing but not fully grown
		local id = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id;
		local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_WEED];
		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	
		local detailId = g_currentMission.terrainDetailId;
		
		setDensityReturnValueShift(id, -1);
        setDensityCompareParams(id, "between", 5, 7);
       
		local resA,resB = setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, detailId, g_currentMission.cultivatorChannel, 1, 9);
		if resA > 0 or resB > 0 then
			-- print("dead weed: "..tostring(resA).." "..tostring(resB))
		end
		
		setDensityCompareParams(id, "greater", -1);
		setDensityReturnValueShift(id, 0);
	end;
	
	
	local area = herbicide.updatePloughArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle);
	
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		local detailId = g_currentMission.terrainDetailId;
		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(detailId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
		local id = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id;
		local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_WEED];
		
		--setDensityParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0)
		setDensityCompareParams(id, "between", -1, 8);
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, detailId, g_currentMission.ploughChannel, 1, 2)
		setDensityCompareParams(id, "greater", -1);
	end;
	return area;
end;


function herbicide.newUpdateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting,killWeed)
	
	if killWeed == nil then
		killWeed = true;
	end;
	
	if killWeed then
		if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then		
			local id = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id;
			local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_WEED];
			local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
		
			local detailId = g_currentMission.terrainDetailId;
			
			setDensityReturnValueShift(id, -1);
			setDensityCompareParams(id, "between", 4, 7);
			setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 4);
			setDensityCompareParams(id, "equals", 8);
			setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 3);
			setDensityCompareParams(id, "between", -1, 1);
			setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 3);
			setDensityCompareParams(id, "greater", -1);
			setDensityReturnValueShift(id, 0);		
		end;
	end;
	
	local numPixels, numDetailPixels = herbicide.updateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting);	
	return numPixels, numDetailPixels;
end;




herbicide.newSprayerUpdateTick = function(self, dt)

	if self.vogelTA ~= nil then -- fix for zumhammer pack
		herbicide.sprayerUpdateTick(self, dt);
	else
		local isHerbicide = Utils.getNoNil(self.isHerbicide,false) and g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil;
		local isSeeder = Utils.getNoNil(self.isSeedSpreader,false);
		
		-- if self.workAreasBackupHerbicide == nil then
			-- self.workAreasBackupHerbicide = self.workAreas;
		-- end;
		if (isHerbicide or isSeeder) and table.getn(self.workAreas) > 0 then
			--self.workAreasBackupHerbicide = self.workAreas;
			self.workAreas = {};
		end;
		
		herbicide.sprayerUpdateTick(self, dt);
		
		if not (isHerbicide or isSeeder) and self.workAreasBackupHerbicide~= nil then
			self.workAreas = self.workAreasBackupHerbicide;	
		end; 
		
		if self.isTurnedOn and self.allowsSpraying and (isHerbicide or isSeeder) then		
			for _,cuttingArea in pairs(self.workAreasBackupHerbicide) do
				if self:getIsAreaActive(cuttingArea) then
					local x,_,z = getWorldTranslation(cuttingArea.start);
					if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
						local x1,_,z1 = getWorldTranslation(cuttingArea.width);
						local x2,_,z2 = getWorldTranslation(cuttingArea.height);
						if isHerbicide then
							local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, x1, z1, x2, z2);
													
							local id = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id;
							local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_WEED];
							
							if true then-- destroy out of field completely
								local excludeMask = 2^g_currentMission.sowingChannel + 2^g_currentMission.sowingWidthChannel + 2^g_currentMission.cultivatorChannel + 2^g_currentMission.ploughChannel;
								local detailId = g_currentMission.terrainDetailId;
								 
								setDensityMaskParams(id, "greater", -1, 0, 0, excludeMask);
								
								setDensityCompareParams(id, "greater", -1);
								
								setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitDensityMapChannels, detailId, g_currentMission.terrainDetailTypeFirstChannel, 		g_currentMission.terrainDetailTypeNumChannels, 0);
															
								setDensityCompareParams(id, "greater", -1);
								setDensityMaskParams(id, "greater", 0);

							end;-- end destroy out of field
							
							setDensityReturnValueShift(id, -1);
							setDensityCompareParams(id, "between", 4, 6);
							setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 1); --kill not fully grown and regrow
							setDensityCompareParams(id, "between", 7, 8);
							setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 8); -- kill fully grown, leave standing
							setDensityCompareParams(id, "greater", -1);
							setDensityReturnValueShift(id, 0);						
							
						else
							--local angle = 0; --insert code later
							local fruit = self.seedSpreaderFruitList[self.seedSpreaderFruitListIndex];
							
							local angleRad = 0;
							if false then
								local dx,dy,dz = localDirectionToWorld(self.rootNode, 0, 0, 1);
								angleRad = Utils.getYRotationFromDirection(dx, dz);
							else
								angleRad = math.random()*2*math.pi;
							end;
							
							local desc = FruitUtil.fruitIndexToDesc[fruit];
							if desc ~= nil and desc.directionSnapAngle ~= 0 then
								angleRad = math.floor(angleRad / desc.directionSnapAngle + 0.5) * desc.directionSnapAngle;
							end

							local angle = Utils.convertToDensityMapAngle(angleRad, g_currentMission.terrainDetailAngleMaxValue);
							
							local doDirectSeed = false;
							if fruit == FruitUtil.FRUITTYPE_GRASS or fruit == FruitUtil.FRUITTYPE_KLEE or FruitUtil.FRUITTYPE_LUZERNE then
								doDirectSeed = true;
							end;
							
							Utils.updateSowingArea(fruit, x, z, x1, z1, x2, z2, angle, doDirectSeed,false);
						end;
					end;
				end;
			end;
		end;
	end;
end;



function herbicide.newCutFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth)
	
	local weedSum = 0;
	local weedSum2 = 0;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		local ids = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED];
		if ids == nil or ids.id == 0 then
			return 0;
		end
		local id = ids.id;
		local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_WEED];
		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	
		local detailId = g_currentMission.terrainDetailId;
		
		setDensityReturnValueShift(id, -1);
		
		-- kill everything that is not on sowingChannel
		local excludeMask = 2^g_currentMission.sowingChannel + 2^g_currentMission.sowingWidthChannel;		
		setDensityMaskParams(id, "greater", 0, 0, 0, excludeMask);
		setDensityCompareParams(id, "greater", -1);		
		setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitDensityMapChannels, detailId, g_currentMission.terrainDetailTypeFirstChannel, 		g_currentMission.terrainDetailTypeNumChannels, 0);				
		setDensityMaskParams(id, "greater", 0);
		
        setDensityCompareParams(id, "between", 5, 7);
        weedSum = setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 4);
		setDensityCompareParams(id, "between", 7, 8);
		weedSum2 = setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 4);
        setDensityCompareParams(id, "greater", -1);
        setDensityReturnValueShift(id, 0);
	end;
	
	local resA, resB, spraySum = herbicide.cutFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth);
	
	if weedSum > 0 or weedSum2 > 0 then
		local leverage = 0.1;		
		if weedSum2 > 0 then
			leverage = 0.065;
		end;
		local factor = 1 - leverage*g_currentMission.missionStats.difficulty;
		resA = resA*factor;		
	end;
	
	--this is new: remove not fully grown stuff as well:
	if true then
		local ids = g_currentMission.fruits[fruitId];
        if ids == nil or ids.id == 0 then
           
        else
			local id = ids.id;
			local desc = FruitUtil.fruitIndexToDesc[fruitId];
			local value = desc.cutState+1;
			local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
			
			setDensityReturnValueShift(id, -1);
			setDensityCompareParams(id, "between", 1, desc.minHarvestingGrowthState+2);
			setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, value);
			setDensityCompareParams(id, "greater", -1);
			setDensityReturnValueShift(id, 0);
		end;
	end;
	
	return resA, resB, spraySum;
end;

function herbicide.newUpdateFruitPreparerArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, startDropWorldX, startDropWorldZ, widthDropWorldX, widthDropWorldZ, heightDropWorldX, heightDropWorldZ)
	
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		local ids = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED];
		if ids == nil or ids.id == 0 then
			return 0;
		end
		local id = ids.id;
		local desc = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_WEED];
		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	
		local detailId = g_currentMission.terrainDetailId;
		
		setDensityReturnValueShift(id, -1);
		
		-- -- -- kill everything that is not on sowingChannel
		local excludeMask = 2^g_currentMission.sowingChannel + 2^g_currentMission.sowingWidthChannel;		
		setDensityMaskParams(id, "greater", 0, 0, 0, excludeMask);
		setDensityCompareParams(id, "greater", -1);		
		setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitDensityMapChannels, detailId, g_currentMission.terrainDetailTypeFirstChannel, 		g_currentMission.terrainDetailTypeNumChannels, 0);				
		setDensityMaskParams(id, "greater", 0);
		
		
		if true then --weed is using up the fertilizer			
			setDensityMaskParams(detailId, "between", 5, 8);
			setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, id, 0, g_currentMission.numFruitStateChannels, 0);
			setDensityMaskParams(detailId, "greater", 0);
		end;
		
        setDensityCompareParams(id, "between", 5, 8);
        setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 4);
		
        setDensityCompareParams(id, "greater", -1);
        setDensityReturnValueShift(id, 0);
	end;
	
	local numChangedPixels = herbicide.updateFruitPreparerArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, startDropWorldX, startDropWorldZ, widthDropWorldX, widthDropWorldZ, heightDropWorldX, heightDropWorldZ)

	
	return numChangedPixels
end;






function Utils.herbicideNewUpdateGUI(self,superFunc)
	
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		local saveID = g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id;
		g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id = 0;
		superFunc(self);
		g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id = saveID;
	else
		superFunc(self);
	end;
end;

-- g_inGameMenu.updateGUI = Utils.overwrittenFunction(g_inGameMenu.updateGUI,Utils.herbicideNewUpdateGUI);
g_statisticView.updateGUI = Utils.overwrittenFunction(g_statisticView.updateGUI,Utils.herbicideNewUpdateGUI);