﻿--
-- Massey Ferguson 7726 Dyna-VT Functions
-- 
-- author  Mythos
-- date  18/08/2015
-- www.ARM-team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

MF7726DVT = {};

function MF7726DVT.prerequisitesPresent(specializations)
    return true;
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:load(xmlFile)
	
	-- Functions
	self.MPCode = SpecializationUtil.callSpecializationsFunction("MPCode");
	
	-- Indexes
	self.coolerFan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.coolerFan#index"));
	
	self.hydBonnetTrigger = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.hydBonnetTrigger#index"));
	self.rightWheelTrigger = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.rightWheelTrigger#index"));
	self.leftWheelTrigger = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.leftWheelTrigger#index"));
	self.leftWheelFTrigger = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.leftWheelFTrigger#index"));
	self.rightWheelFTrigger = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.rightWheelFTrigger#index"));
	
	self.LDW = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.LDW#index"));
	self.RDW = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.RDW#index"));
	self.LFEN = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.LFEN#index"));
	self.RFEN = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.RFEN#index"));
	
	self.rightWheels = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.rightWheels.rightWheel(%d)", i);
		local wheel = Utils.indexToObject(self.components,getXMLString(xmlFile, key.. "#index"));
		if wheel == nil then
			break;
		end;
		table.insert(self.rightWheels, wheel);
		i = i + 1;
	end;
	
	self.leftWheels = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.leftWheels.leftWheel(%d)", i);
		local wheel = Utils.indexToObject(self.components,getXMLString(xmlFile, key.. "#index"));
		if wheel == nil then
			break;
		end;
		table.insert(self.leftWheels, wheel);
		i = i + 1;
	end;
	
	self.changeRWheel = 1;
	self.changeLWheel = 1;
	
	-- Booleans
	self.LKG = true;
	self.LKGF = false;
	self.ct = 4000;
	self.BNT = false;
	self.LDWM = false;
	self.RDWM = false;
	self.LFENM = true;
	self.RFENM = true;
	
	-- Animations
	self.bonnetAnim = getXMLString(xmlFile, "vehicle.bonnetAnim#animationName");
	self.frontLinkageAnim = getXMLString(xmlFile, "vehicle.frontLinkageAnim#animationName");
	self.frontLinkageSAFETYAnim = getXMLString(xmlFile, "vehicle.frontLinkageSAFETYAnim#animationName");

end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:delete()
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:mouseEvent(posX, posY, isDown, isUp, button)
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:keyEvent(unicode, sym, modifier, isDown)
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:update(dt)
	
	if getUserInRange(self.hydBonnetTrigger, 0.5) then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MF7726_LINKAGE_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:MPCode(1, not self.LKG); -- Open/Close front Linkage
		end;
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MF7726_BONNET_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:MPCode(2, not self.BNT); -- Open/CLose Bonnet
		end;
	elseif getUserInRange(self.rightWheelTrigger, 1.5) then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MF7726_RW_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.changeRWheel = self.changeRWheel+1;
			if self.changeRWheel == 4 then
				self.changeRWheel = 1;
			end;
			self:MPCode(3, nil, self.changeRWheel); -- Change Right Wheel
		end;
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MF7726_DW_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:MPCode(6, not self.RDWM); -- Right Double Wheel
		end;
	elseif getUserInRange(self.leftWheelTrigger, 1.5) then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MF7726_LW_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.changeLWheel = self.changeLWheel+1;
			if self.changeLWheel == 4 then
				self.changeLWheel = 1;
			end;
			self:MPCode(4, nil, self.changeLWheel); -- Change Left Wheel
		end;
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MF7726_DW_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:MPCode(5, not self.LDWM); -- Left Double Wheel
		end;
	elseif getUserInRange(self.leftWheelFTrigger, 1.0) then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MF7726_FEN_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:MPCode(7, not self.LFENM); -- Left Mudguard
		end;
	elseif getUserInRange(self.rightWheelFTrigger, 1.0) then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MF7726_FEN_MODE"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:MPCode(8, not self.RFENM); -- Right Mudguard
		end;
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:updateTick(dt)
	if self.isMotorStarted then
		rotate(self.coolerFan, 0, 0, dt*0.005);
	end;
	
	if self.LKGF then
		self.ct = self.ct - dt;
		if self.ct <0 then
			self.LKGF = false;
			self.ct = 4000;
		end;
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function getUserInRange(node, minDistance)
	local result = false;
	local px, py, pz = getWorldTranslation(node);
	local Pl = 0;
	for k,v in pairs(g_currentMission.players) do
		if g_currentMission.players[k].isControlled then
			Pl = g_currentMission.players[k].rootNode;
			break;
		end;
	end;
	if Pl ~= 0 then
		local vx, vy, vz = getWorldTranslation(Pl);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < minDistance then		
			result = true;
		end;
	end;
	return result;
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:MPCode(mode, state, a1, noEventSend)
	MF7726DVTEvent.sendEvent(self, mode, state, a1, noEventSend);

--______________________________________________________________________________
	if mode == 10 then
--_____________________________________  LINKAGE SAFETY MODE ______________________________
		self:playAnimation(self.frontLinkageSAFETYAnim, 100, nil, true);
		self.LKG = true;
--______________________________________________________________________________
	elseif mode == 11 then
--_____________________________________  LINKAGE MODE ______________________________
		self:playAnimation(self.frontLinkageAnim, 100, nil, true);
		self.LKG = true;
--______________________________________________________________________________
	elseif mode == 12 then
--_____________________________________  LINKAGE MODE ______________________________
		self:playAnimation(self.frontLinkageAnim, -100, nil, true);
		self.LKG = false;
--______________________________________________________________________________
	elseif mode == 1 then
--_____________________________________  LINKAGE MODE ______________________________
		if state then
			self:playAnimation(self.frontLinkageAnim, 1, nil, true);
			self.LKG = true;
		else
			local sum = table.getn(self.attachedImplements);
			if sum ~= 0 then
				for i=1, sum do
					local implement = self.attachedImplements[i];
					local jointDescIndex = implement.jointDescIndex;
					if jointDescIndex ==2 then
						self.LKGF = true;
						g_currentMission:showBlinkingWarning(g_i18n:getText("MF7726_DETACH_IMPLEMENT_FIRST"), 4000);
						break;
					end;
				end;
				if not self.LKGF then
					self:playAnimation(self.frontLinkageAnim, -1, nil, true);
					self.LKG = false;
				end;
			else
				self:playAnimation(self.frontLinkageAnim, -1, nil, true);
				self.LKG = false;
			end;
		end;
--______________________________________________________________________________
	elseif mode == 2 then
--_____________________________________  BONNET MODE ______________________________
		if state then
			self:playAnimation(self.bonnetAnim, 1, nil, true);
			self.BNT = true;
		else
			self:playAnimation(self.bonnetAnim, -1, nil, true);
			self.BNT = false;
		end;
--______________________________________________________________________________
	elseif mode == 3 then
--_____________________________________  RIGHT WHEEL MODE ______________________________
		if a1 == 1 then
			setVisibility(self.rightWheels[1], true);
			setVisibility(self.rightWheels[2], false);
			setVisibility(self.rightWheels[3], false);
		elseif a1 == 2 then
			setVisibility(self.rightWheels[1], false);
			setVisibility(self.rightWheels[2], true);
			setVisibility(self.rightWheels[3], false);
		elseif a1 == 3 then
			setVisibility(self.rightWheels[1], false);
			setVisibility(self.rightWheels[2], false);
			setVisibility(self.rightWheels[3], true);
		end;
--______________________________________________________________________________
	elseif mode == 4 then
--_____________________________________  LEFT WHEEL MODE ______________________________
		if a1 == 1 then
			setVisibility(self.leftWheels[1], true);
			setVisibility(self.leftWheels[2], false);
			setVisibility(self.leftWheels[3], false);
		elseif a1 == 2 then
			setVisibility(self.leftWheels[1], false);
			setVisibility(self.leftWheels[2], true);
			setVisibility(self.leftWheels[3], false);
		elseif a1 == 3 then
			setVisibility(self.leftWheels[1], false);
			setVisibility(self.leftWheels[2], false);
			setVisibility(self.leftWheels[3], true);
		end;
--______________________________________________________________________________
	elseif mode == 5 then
--_____________________________________  LEFT DOUBLE WHEEL MODE ______________________________
		if state then
			setVisibility(self.LDW, true);
			self.LDWM = true;
		else
			setVisibility(self.LDW, false);
			self.LDWM = false;
		end;
--______________________________________________________________________________
	elseif mode == 6 then
--_____________________________________  RIGHT DOUBLE WHEEL MODE ______________________________
		if state then
			setVisibility(self.RDW, true);
			self.RDWM = true;
		else
			setVisibility(self.RDW, false);
			self.RDWM = false;
		end;
--______________________________________________________________________________
	elseif mode == 7 then
--_____________________________________  LEFT FENDER MODE ______________________________
		if state then
			setVisibility(self.LFEN, true);
			self.LFENM = true;
		else
			setVisibility(self.LFEN, false);
			self.LFENM = false;
		end;
--______________________________________________________________________________
	elseif mode == 8 then
--_____________________________________  RIGHT FENDER MODE ______________________________
		if state then
			setVisibility(self.RFEN, true);
			self.RFENM = true;
		else
			setVisibility(self.RFEN, false);
			self.RFENM = false;
		end;
	end;

end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:draw()
	
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	if not resetVehicles then
		self.LKG = Utils.getNoNil(getXMLBool(xmlFile, key.."#LKG"),false);
		self.BNT = Utils.getNoNil(getXMLBool(xmlFile, key.."#BNT"),false);
		self.changeRWheel = Utils.getNoNil(getXMLInt(xmlFile, key.."#RRW"),1);
		self.changeLWheel = Utils.getNoNil(getXMLInt(xmlFile, key.."#RLW"),1);
		self.RDWM = Utils.getNoNil(getXMLBool(xmlFile, key.."#RDWM"),false);
		self.LDWM = Utils.getNoNil(getXMLBool(xmlFile, key.."#LDWM"),false);
		self.RFENM = Utils.getNoNil(getXMLBool(xmlFile, key.."#RFENM"),true);
		self.LFENM = Utils.getNoNil(getXMLBool(xmlFile, key.."#LFENM"),true);
		
		if self.LKG then
			local vehId = getXMLInt(xmlFile, key.."#id")
			local i = 0;
			local safety = false;
			while true do
				local akey = string.format("careerVehicles.attachment(%d)", i);
				local id0 = getXMLInt(xmlFile, akey.."#id0");
				if id0 == nil then
					break;
				end;
				local id1 = getXMLInt(xmlFile, akey.."#id1");
				if id0==vehId or id1==vehId then
					local jIndex = getXMLInt(xmlFile, akey.."#jointIndex");
					if jIndex == 2 then
						self:MPCode(10);
						safety = true;
						break;
					end;
				end;
				i = i + 1;
			end;
			if not safety then
				self:MPCode(11);
			end;
		else
			self:MPCode(12);
		end;
		
		self:MPCode(2, self.BNT);
		self:MPCode(3, nil, self.changeRWheel);
		self:MPCode(4, nil, self.changeLWheel);
		self:MPCode(5, self.LDWM);
		self:MPCode(6, self.RDWM);
		self:MPCode(7, self.LFENM);
		self:MPCode(8, self.RFENM);
		
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'LKG="'..tostring(self.LKG)..
	'" BNT="'..tostring(self.BNT)..
	'" RRW="'..tostring(self.changeRWheel)..
	'" RLW="'..tostring(self.changeLWheel)..
	'" RDWM="'..tostring(self.RDWM)..
	'" LDWM="'..tostring(self.LDWM)..
	'" RFENM="'..tostring(self.RFENM)..
	'" LFENM="'..tostring(self.LFENM)..'"';

	local nodes = nil;
	
	return attributes,nodes;
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:readStream(streamId, connection)
	self.LKG = streamReadBool(streamId);
	self.BNT = streamReadBool(streamId);
	self.changeRWheel = streamReadInt32(streamId);
	self.changeLWheel = streamReadInt32(streamId);
	self.LDWM = streamReadBool(streamId);
	self.RDWM = streamReadBool(streamId);
	self.RFENM = streamReadBool(streamId);
	self.LFENM = streamReadBool(streamId);
end;

--________________________________________________________________________________________________________________________________________________________
function MF7726DVT:writeStream(streamId, connection)
	streamWriteBool(streamId, self.LKG);
	streamWriteBool(streamId, self.BNT);
	streamWriteInt32(streamId, self.changeRWheel);
	streamWriteInt32(streamId, self.changeLWheel);
	streamWriteBool(streamId, self.RDWM);
	streamWriteBool(streamId, self.LDWM);
	streamWriteBool(streamId, self.LFENM);
	streamWriteBool(streamId, self.RFENM);
end;

--**********************************************************************************************************************************************************************************
MF7726DVTEvent = {};
MF7726DVTEvent_mt = Class(MF7726DVTEvent, Event);

InitEventClass(MF7726DVTEvent, "MF7726DVTEvent");

function MF7726DVTEvent:emptyNew()
    local self = Event:new(MF7726DVTEvent_mt);
    self.className="MF7726DVTEvent";
    return self;
end;

function MF7726DVTEvent:new(vehicle, mode, state, a1)
    local self = MF7726DVTEvent:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
	self.a1 = a1;
    return self;
end;

function MF7726DVTEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
	self.a1 = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MF7726DVTEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
	streamWriteInt32(streamId, self.a1);
end;

function MF7726DVTEvent:run(connection)
	self.vehicle:MPCode(self.mode, self.state, self.a1, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MF7726DVTEvent:new(self.vehicle, self.mode, self.state, self.a1), nil, connection, self.vehicle);
    end;
end;

function MF7726DVTEvent.sendEvent(vehicle, mode, state, a1, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MF7726DVTEvent:new(vehicle, mode, state, a1), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MF7726DVTEvent:new(vehicle, mode, state, a1));
		end;
	end;
end;