--
-- DraytonFarm
--
-- @author  Stefan Geiger
-- @date  12/07/10
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

DraytonFarm = {}

local DraytonFarm_mt = Class(DraytonFarm, Mission00);


function DraytonFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = DraytonFarm_mt;
    end;
    local self = DraytonFarm:superClass():new(baseDirectory, mt);

    return self;
end;

function DraytonFarm:delete()
    DraytonFarm:superClass().delete(self);
end;

function DraytonFarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/DraytonFarm.i3d", self.baseDirectory), true, self.loadCareerMap01Finished, self);
end;

function DraytonFarm:loadCareerMap01Finished(node, arguments)
    if self.cancelLoading then
        return;
    end
    local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("DraytonFarm.xml", self.baseDirectory));
    trcScreenFlip();
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
	trcScreenFlip();
    self.ingameMap:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
	
	trcScreenFlip();
    DraytonFarm:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
end;

function DraytonFarm:onStartMission()
    DraytonFarm:superClass().onStartMission(self);
end;

function DraytonFarm:mouseEvent(posX, posY, isDown, isUp, button)
    DraytonFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function DraytonFarm:keyEvent(unicode, sym, modifier, isDown)
    DraytonFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function DraytonFarm:update(dt)
    DraytonFarm:superClass().update(self, dt);
end;

function DraytonFarm:draw()
    DraytonFarm:superClass().draw(self);
end;
