local metadata = {
"## Interface: FS15 1.1.0.0 RC12",
"## Title: SwitchWheels",
"## Notes: Specialization zum wechseln der Reifen",
"## Author: Marhu",
"## Version: 1.0.0-53",
"## Date: 21.08.2015",
"## Web: http://Marhu.net"
}

local function L(name)
	return g_i18n:hasText("SwitchWheels_"..name) and g_i18n:getText("SwitchWheels_"..name) or "*"..name;
end

SwitchWheels = {};

function SwitchWheels.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function SwitchWheels:load(xmlFile)
	self.setWheelSet = SwitchWheels.setWheelSet;

	self.dynamicallyWheels = {}
	
	local WheelSet = 1
	local i = 0
	while true do
		local key = string.format("vehicle.dynamicallyLoadedParts.dynamicallyLoadedPart(%d)", i)
		if not hasXMLProperty(xmlFile, key) then
			break
		end
		local dynWheel = {};
		dynWheel.filename = getXMLString(xmlFile, key .. "#filename");
		dynWheel.node = getXMLString(xmlFile, key .. "#node");
		dynWheel.linkNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile, key .. "#linkNode"), "0>"));
		dynWheel.radius = self.wheels[i+1] and self.wheels[i+1].radius or 1;
		dynWheel.width = self.wheels[i+1] and self.wheels[i+1].width or dynWheel.radius * 0.8;
		dynWheel.tyreTrackIndex = self.wheels[i+1] and self.wheels[i+1].tyreTrackIndex or nil;
		dynWheel.tireType = self.wheels[i+1] and self.wheels[i+1].tireType or nil;
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key .. "#position"));
        if x ~= nil and y ~= nil and z ~= nil then
			dynWheel.x = x;
			dynWheel.y = y;
			dynWheel.z = z;
		end
		local rotX, rotY, rotZ = Utils.getVectorFromString(getXMLString(xmlFile, key .. "#rotation"));
		if rotX ~= nil and rotY ~= nil and rotZ ~= nil then
			dynWheel.rotX = Utils.degToRad(rotX);
			dynWheel.rotY = Utils.degToRad(rotY);
			dynWheel.rotZ = Utils.degToRad(rotZ);
		end;
		local shaderParameterName = getXMLString(xmlFile, key .. "#shaderParameterName");
		local x,y,z,w = Utils.getVectorFromString(getXMLString(xmlFile, key .. "#shaderParameter"));
		if shaderParameterName ~= nil and x ~= nil and y ~= nil and z ~= nil and w ~= nil then
			dynWheel.shader={}
			dynWheel.shader.shaderParameterName = shaderParameterName;
			dynWheel.shader.x = x;
			dynWheel.shader.y = y;
			dynWheel.shader.z = z;
			dynWheel.shader.w = w;
		end;
		
		if not self.dynamicallyWheels[WheelSet] then self.dynamicallyWheels[WheelSet] = {} end;
		table.insert(self.dynamicallyWheels[WheelSet],dynWheel)
		i = i + 1
	end
		
	local j = 1
	while true do	
		local key = string.format("vehicle.dynamicallyWheels%d.dynamicallyWheel(%d)", j, 0)
		if not hasXMLProperty(xmlFile, key) then
			break
		end
		WheelSet = WheelSet + 1;
		local i = 0
		while true do
			local key = string.format("vehicle.dynamicallyWheels%d.dynamicallyWheel(%d)", j, i)
			if not hasXMLProperty(xmlFile, key) then
				break
			end
			local dynWheel = {};
			dynWheel.filename = getXMLString(xmlFile, key .. "#filename");
			dynWheel.node = getXMLString(xmlFile, key .. "#node");
			dynWheel.linkNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile, key .. "#linkNode"), "0>"));
			dynWheel.radius = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#radius"), 1);
			dynWheel.width = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#width"), dynWheel.radius * 0.8);
			dynWheel.tyreTrackIndex = g_currentMission.tyreTrackSystem:createTrack(dynWheel.width, Utils.getNoNil(getXMLInt(xmlFile,key .. "#tyreTrackAtlasIndex"), 0));
			dynWheel.tireType = WheelsUtil.getTireType( Utils.getNoNil(getXMLString(xmlFile, key .. "#tireType"), "mud"));
			local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key .. "#position"));
			if x ~= nil and y ~= nil and z ~= nil then
				dynWheel.x = x;
				dynWheel.y = y;
				dynWheel.z = z;
			end
			local rotX, rotY, rotZ = Utils.getVectorFromString(getXMLString(xmlFile, key .. "#rotation"));
			if rotX ~= nil and rotY ~= nil and rotZ ~= nil then
				dynWheel.rotX = Utils.degToRad(rotX);
				dynWheel.rotY = Utils.degToRad(rotY);
				dynWheel.rotZ = Utils.degToRad(rotZ);
			end;
			local shaderParameterName = getXMLString(xmlFile, key .. "#shaderParameterName");
			local x,y,z,w = Utils.getVectorFromString(getXMLString(xmlFile, key .. "#shaderParameter"));
			if shaderParameterName ~= nil and x ~= nil and y ~= nil and z ~= nil and w ~= nil then
				dynWheel.shader={}
				dynWheel.shader.shaderParameterName = shaderParameterName;
				dynWheel.shader.x = x;
				dynWheel.shader.y = y;
				dynWheel.shader.z = z;
				dynWheel.shader.w = w;
			end;
			if not self.dynamicallyWheels[WheelSet] then self.dynamicallyWheels[WheelSet] = {} end;
			table.insert(self.dynamicallyWheels[WheelSet],dynWheel)
			i = i + 1
		end
		j = j + 1
	end	
	
	local num = table.getn(self.dynamicallyWheels);
	if self.dynamicallyWheels[1] ~= nil and num >= 2 then
		local numDynamicallyParts = table.getn(self.dynamicallyWheels[1]);
		for i = numDynamicallyParts,1,-1 do
			if self.dynamicallyWheels[num][i] == nil then
				table.remove(self.dynamicallyWheels[1], i);
			end;
		end;
	else
		WheelSet = 0;
		self.dynamicallyWheels[1]={};
	end;
	
	self.WheelSet = 1;
	self.maxWheelSets = WheelSet;
end;
function SwitchWheels:delete()
end;
function SwitchWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;
function SwitchWheels:keyEvent(unicode, sym, modifier, isDown)
end;
function SwitchWheels:update(dt)
	if self:getIsActiveForInput(true) then
		if InputBinding.hasEvent(InputBinding.SWITCHWHEELS_SWITCH) then
			self.WheelSet = self.WheelSet + 1;
			if self.maxWheelSets < self.WheelSet then
				self.WheelSet = 1;
			end
			self:setWheelSet(self.WheelSet)
		end
	end;
end;
function SwitchWheels:draw()
	if self:getIsActiveForInput(true) then
		g_currentMission:addHelpButtonText(L("SwitchWheels"), InputBinding.SWITCHWHEELS_SWITCH);
	end;
end;
function SwitchWheels:setWheelSet(WheelSet, noEventSend)

	SwitchWheelsSetWheelEvent.sendEvent(self, WheelSet, noEventSend)
	
	self.WheelSet = WheelSet;
	local WS = self.dynamicallyWheels[self.WheelSet];
	
	for i = 1,table.getn(WS) do
		local i3dNode = Utils.loadSharedI3DFile(WS[i].filename, self.baseDirectory, false, false, false);
		if i3dNode ~= 0 then
			local node = Utils.indexToObject(i3dNode, WS[i].node);
			if WS[i].x ~= nil and WS[i].y ~= nil and WS[i].z ~= nil then
				setTranslation(node, WS[i].x,WS[i].y,WS[i].z);
			end;
			if WS[i].rotX ~= nil and WS[i].rotY ~= nil and WS[i].rotZ ~= nil then
				setRotation(node, WS[i].rotX, WS[i].rotY, WS[i].rotZ);
			end;
			if WS[i].shader then
				setShaderParameter(node, WS[i].shader.shaderParameterName, WS[i].shader.x, WS[i].shader.y, WS[i].shader.z, WS[i].shader.w, false);
			end;
			local num = getNumOfChildren(WS[i].linkNode);
			if  num > 0 then
				local old = getChildAt(WS[i].linkNode,num-1)
				self:removeWashableNode(old)
				delete(old);
			end

			local x, _, z, w = getShaderParameter(node, "RDT")
			setShaderParameter(node, "RDT", x, self.dirtAmount, z, w, false)
			self:addWashableNode(node)

			link(WS[i].linkNode, node);
			delete(i3dNode);
			if self.wheels[i] then
				self.wheels[i].radius = WS[i].radius;
				if self.wheels[i].tyreTrackIndex then self.wheels[i].tyreTrackIndex = WS[i].tyreTrackIndex; end;
				if self.wheels[i].tireType then self.wheels[i].tireType = WS[i].tireType; end;
				self:updateWheelBase(self.wheels[i]);
			end;
		end;
	end;
end;

SwitchWheelsSetWheelEvent = {}
SwitchWheelsSetWheelEvent_mt = Class(SwitchWheelsSetWheelEvent, Event)
InitEventClass(SwitchWheelsSetWheelEvent, "SwitchWheelsSetWheelEvent")
function SwitchWheelsSetWheelEvent:emptyNew()
	local self = Event:new(SwitchWheelsSetWheelEvent_mt);
	return self;
end
function SwitchWheelsSetWheelEvent:new(object, WheelSet)
	local self = SwitchWheelsSetWheelEvent:emptyNew();
	self.object = object;
	self.WheelSet = WheelSet;
	return self;
end
function SwitchWheelsSetWheelEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId)
	self.WheelSet = streamReadInt8(streamId)
	self.object = networkGetObject(id)
	self:run(connection)
end
function SwitchWheelsSetWheelEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object))
	streamWriteInt8(streamId, self.WheelSet)
end
function SwitchWheelsSetWheelEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object)
	end

	if self.object ~= nil then
		self.object:setWheelSet(self.WheelSet, true)
	end
end
function SwitchWheelsSetWheelEvent.sendEvent(vehicle, WheelSet, noEventSend)
	if (noEventSend == nil or noEventSend == false) then
		if g_server ~= nil then
			g_server:broadcastEvent(SwitchWheelsSetWheelEvent:new(vehicle, WheelSet), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(SwitchWheelsSetWheelEvent:new(vehicle, WheelSet))
		end
	end;
end