--
-- Straw Specialization for Combines
--
-- @author  Templaer
-- @date  24/05/09


strawSpec = {};

function strawSpec.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function strawSpec:load(xmlFile)
	self.setStrawSpecActive = SpecializationUtil.callSpecializationsFunction("setStrawSpecActive");

    -- Backup of Chopper Blind
    self.backupChopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));

    -- Straw Active Boolean
    self.strawActive = true;
end;

function strawSpec:readStream(streamId, connection)
	self:setStrawSpecActive(streamReadBool(streamId), true);
end;

function strawSpec:writeStream(streamId, connection)
	streamWriteBool(streamId, self.strawActive);
end;

function strawSpec:delete()
end;

function strawSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function strawSpec:keyEvent(unicode, sym, modifier, isDown)
	--[[if self:getIsActiveForInput() and self.isEntered then
		if InputBinding.hasEvent(InputBinding.STRAW_PINK) then
			self.strawActive = not self.strawActive;
		    self:setStrawSpecActive(not self.strawActive)

    -- Check for input
	if self:getIsActive() and self.isEntered then
		if InputBinding.hasEvent(InputBinding.STRAW_PINK) then
		    self:setStrawSpecActive(not self.strawActive);
		end;
		end;]]
end;

function strawSpec:update(dt)
	if self:getIsActive() and self.isEntered then
		if InputBinding.hasEvent(InputBinding.STRAW_PINK) then
		    self:setStrawSpecActive(not self.strawActive);
			end;
	end;
		
		-- Check if straw is enabled
        if not self.strawActive then
		    self.strawEmitState = false;
			self.strawEnableTime = nil;
			self.chopperActivated = true;
			self.chopperBlind = nil;
			
			-- Lower the chopper
					local chopperBlindRotationSpeed = 0.001;
					local minRotX = -83*3.1415/180.0;
			
			if self.backupChopperBlind ~= nil then
                local x,y,z = getRotation(self.backupChopperBlind);
			
                x = x-dt*chopperBlindRotationSpeed;
                if x < minRotX then
                    x = minRotX;
                end;
			    setRotation(self.backupChopperBlind, x, y, z);
			end;
					
            -- Enable chopper particle system					
			if self.lastArea > 0 then
			    if self.chopperActivated then
                    if self.chopperEnableTime == nil then
                        self.chopperEnableTime = self.time + self.chopperToggleTime;
                    else
                        self.chopperDisableTime = nil;
                    end;
                    disableChopperEmit = false;
			    end;
			
			    -- Chopper starting delay
			    if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
			
                    self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
			
                    if self.currentChopperParticleSystem == nil then
                        self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
                    end;
                    Utils.setEmittingState(self.currentChopperParticleSystem, true);
				
			    end;
			
	    elseif self.strawActive then
		    self.chopperBlind = self.backupChopperBlind;
		end;
		end;
		if self.strawActive then
		self:setAnimationTime(5, self.animationParts[5].offSet, false); 
           else
		self:setAnimationTime(5, self.animationParts[5].animDuration, false); 
	end;
		--[[if self.strawActive then
			self:setAnimationTime(9, 0);
		self:setAnimationTime(10, self.animationParts[10].offSet, false); 
           else
			self:setAnimationTime(9, 9);
		self:setAnimationTime(10, self.animationParts[10].animDuration, false); 
	end;]]
end;

function strawSpec:draw()
    -- Add text to the HUD
    if self.strawActive then
        g_currentMission:addHelpButtonText(g_i18n:getText("strawCutOn"), InputBinding.STRAW_PINK);
    else
	    g_currentMission:addHelpButtonText(g_i18n:getText("strawCutOff"), InputBinding.STRAW_PINK);
	end;
end;

function strawSpec:setStrawSpecActive(isActive, noEventSend)
	self.strawActive = isActive;
	if noEventSend ~= true then
		StrawSpecEvent.sendEvent(self, isActive);
	end;
end;