--
-- MultiPowerShaftAttacher
-- Specialization for MultiPowerShaftAttacher
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--              v3.0 - Updated by Alex2009 MultiPowerShaftAttacher
--
-- @edit: Alex2009(www.alex2009.de) The script now accepts more than one attacher

MultiPowerShaftAttacher = {};

function MultiPowerShaftAttacher.prerequisitesPresent(specializations)
    return true;
end;

function MultiPowerShaftAttacher:load(xmlFile)
	
	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;		
		local joint = self.attacherJoints[i+1];  
        joint.MultipowerShaftAttacher = {}; 
        local ia=0;
        while true do
            local shaftName = string.format(baseName .. "#shaft%d", ia);
            local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile,shaftName));
            if shaftAttacher == nil then
                break;
            end;
            if shaftAttacher ~= nil then
                table.insert(joint.MultipowerShaftAttacher,ia,shaftAttacher);
            end;
            ia=ia+1;
        end;
		i = i + 1;
	end;

	local attacherJointCount = i;
	i = 0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;

        local joint = self.attacherJoints[attacherJointCount + 1 + i];
        joint.MultipowerShaftAttacher = {};
        local ia=0;
        while true do
            local shaftName = string.format(baseName .. "#shaft%d", ia);
            local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile,shaftName));
            if shaftAttacher == nil then
                break;
            end;
            local joint = self.attacherJoints[attacherJointCount + 1 + i];
            if shaftAttacher ~= nil then
                table.insert(joint.MultipowerShaftAttacher,ia,shaftAttacher);
            end;
            ia=ia+1;
        end;
        i = i+1;
    end;	
end;

function MultiPowerShaftAttacher:delete()
end;

function MultiPowerShaftAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MultiPowerShaftAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function MultiPowerShaftAttacher:update(dt)
end;

function MultiPowerShaftAttacher:draw()
end;




