--
-- Specialization for IntroSound
--
-- @author  	***Gya*** IFF_Team( http://web.italianfarmers.net/ )
-- @version 	v1.0
-- @date  		20/10/13
-- @history:	v1.0 - Initial version
--
--
--

IntroSound = {};

function IntroSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function IntroSound:load(xmlFile)
	
    self.myDors = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myDors#index"));
    self.myDord = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myDord#index"));
	
	--self.OpenDosc = false;

	self.cameraCount  = 2;	
	self.intCameraIndex = 1;
	local passengerCameraIndex = self.intCameraIndex;
end;

function IntroSound:delete()
end;

function IntroSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function IntroSound:keyEvent(unicode, sym, modifier, isDown)
end

function IntroSound:update(dt)	
	  
	-- Reference di sounds interno_Porta Chiusa/Aperta --
	local x,y,z = getRotation(self.myDord);
	if y >= Utils.degToRad(0.5)  then
	   self.OpenDosc = true;
	   
	   else
	   
	local x,y,z = getRotation(self.myDord);
	if y > 0 and y < Utils.degToRad(0.8) then
	   self.OpenDosc = false;
	   end;
	   end;

	local x,y,z = getRotation(self.myDors);
	if y <= Utils.degToRad(-0.5) then
	   self.OpenDosc = true;
	
	   else
	   
	local x,y,z = getRotation(self.myDors);
	if y < 0 and y > Utils.degToRad(-0.8) then
	   self.OpenDosc = false;
	   end;	
end;
	  
	-- percentual sounds _ interno/porta chiusa > interno/porta aperta > esterno--
	--Motor Sound
	if self.motorSound ~= nil then
		if self.camIndex == self.intCameraIndex and not self.OpenDosc then
			setSampleVolume(self.motorSound, self.motorSoundVolume/6);
		elseif self.camIndex == self.intCameraIndex and self.OpenDosc then
			setSampleVolume(self.motorSound, self.motorSoundVolume/3);
		else
			setSampleVolume(self.motorSound, self.motorSoundVolume );
		end;
	end;
	if self.motorStartSound ~= nil then
		if self.camIndex == self.intCameraIndex  and not self.OpenDosc then
			setSampleVolume(self.motorStartSound, self.motorStartSoundVolume/6);
		elseif self.camIndex == self.intCameraIndex  and self.OpenDosc then
			setSampleVolume(self.motorStartSound, self.motorStartSoundVolume/3);
		else
			setSampleVolume(self.motorStartSound, self.motorStartSoundVolume );
		end;
	end;
	
	if self.motorStopSound ~= nil then
		if self.camIndex == self.intCameraIndex  and not self.OpenDosc then
			setSampleVolume(self.motorStopSound, self.motorStopSoundVolume/6);
		elseif self.camIndex == self.intCameraIndex  and self.OpenDosc then
			setSampleVolume(self.motorStopSound, self.motorStopSoundVolume/3);
		else
			setSampleVolume(self.motorStopSound, self.motorStopSoundVolume );
		end;
	end;
	
	--[[if self.motorSoundLeave ~= nil then
		if self.camIndex == self.intCameraIndex and not self.OpenDosc  then
			setSampleVolume(self.motorSoundLeave,self.motorSoundLeaveVolume/7);
		elseif self.camIndex == self.intCameraIndex and self.OpenDosc  then
			setSampleVolume(self.motorSoundLeave,self.motorSoundLeaveVolume/3);
		else
			setSampleVolume(self.motorSoundLeave,self.motorSoundLeaveVolume );
		end;
	end;]]
	
	--Theshing sound
	
	if self.threshingSound ~= nil then
		if self.camIndex == self.intCameraIndex  and not self.OpenDosc then
			setSampleVolume(self.threshingSound,self.threshingSoundVolume/6);
		elseif self.camIndex == self.intCameraIndex  and self.OpenDosc then
			setSampleVolume(self.threshingSound,self.threshingSoundVolume/3);
		else
			setSampleVolume(self.threshingSound,self.threshingSoundVolume );
		end;
	end;
	
	if self.threshingStartSound ~= nil then
		if self.camIndex == self.intCameraIndex and not self.OpenDosc  then
			setSampleVolume(self.threshingStartSound,self.threshingStartSoundVolume/6);
		elseif self.camIndex == self.intCameraIndex and self.OpenDosc  then
			setSampleVolume(self.threshingStartSound,self.threshingStartSoundVolume/3);
		else
			setSampleVolume(self.threshingStartSound,self.threshingStartSoundVolume );
		end;
	end;
	
	if self.threshingStopSound ~= nil then
		if self.camIndex == self.intCameraIndex and not self.OpenDosc  then
			setSampleVolume(self.threshingStopSound,self.threshingStopSoundVolume/6);
		elseif self.camIndex == self.intCameraIndex and self.OpenDosc  then
			setSampleVolume(self.threshingStopSound,self.threshingStopSoundVolume/3);
		else
			setSampleVolume(self.threshingStopSound,self.threshingStopSoundVolume );
		end;
	end;
	
	--Hydro Sounds
	
	
	if self.hydraulicSound ~= nil then
		if self.camIndex == self.intCameraIndex  and not self.OpenDosc then
			setSampleVolume(self.hydraulicSound,self.hydraulicSoundVolume/7);
		elseif self.camIndex == self.intCameraIndex  and self.OpenDosc then
			setSampleVolume(self.hydraulicSound,self.hydraulicSoundVolume/4);
		else
			setSampleVolume(self.hydraulicSound,self.hydraulicSoundVolume );
		end;
	end;
	
	--Warning
	
	if self.WarningSound ~= nil then
		if self.camIndex == self.intCameraIndex  then
			setSampleVolume(self.WarningSound, self.WarningSoundVolume);
		else
			setSampleVolume(self.WarningSound, self.WarningSoundVolume/8 );
		end;
	end;
	
	--PipeSound
	
	
	if self.pipeSound ~= nil then
		if self.camIndex == self.intCameraIndex  and not self.OpenDosc then
			setSampleVolume(self.pipeSound,self.pipeSoundVolume/6);
		elseif self.camIndex == self.intCameraIndex  and self.OpenDosc then
			setSampleVolume(self.pipeSound,self.pipeSoundVolume/3);
		else
			setSampleVolume(self.pipeSound,self.pipeSoundVolume );
		end;
	end;
end;

function IntroSound:draw()
end;
