--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	self.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.interactiveComponents.buttons#count"), 0);	
	if self.count ~= 0 then	
		for i=1, self.count do	
			local buttonName = string.format("vehicle.interactiveComponents.buttons.button%d", i);	
			local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
			local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
			local highlight = getChildAt(mark, 0);
			local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
			local event = getXMLString(xmlFile, buttonName .. "#event");
			local onMessage = g_i18n:getText("ic_button_on");
			local offMessage = g_i18n:getText("ic_button_off");
		
			local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage);

			table.insert(self.interactiveObjects, button);
		end;
	end;
	
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  25/12/09
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.event == "toggleBeaconLights" then
		if self.vehicle ~= nil then
			self.isOpen = self.vehicle.beaconLightsActive;
		end;
	end;
	if self.event == "togglePipe" then
		if self.vehicle ~= nil then
			self.isOpen = self.vehicle.targetPipeState ~= 1;
		end;
	end;
	if self.event == "toggleThreshing" then
		if self.vehicle ~= nil then
			self.isOpen = self.vehicle.isThreshing;
		end;
	end;
	if self.event == "toggleOpenGT" then
		if self.vehicle ~= nil then
			self.isOpen = self.vehicle.OpenGT;
		end;
	end;
	if self.event == "toggleModeMonitor" then
		if self.vehicle ~= nil then
			self.isOpen = self.vehicle.MonitorTool;
		end;
	end;
	if self.vehicle ~= nil then
		if self.event == "toggleMotorIgnition" then		
			self.isOpen = self.vehicle.isMotorStarted;
		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
	if self.event == "toggleFrontlights" then
		if self.vehicle ~= nil then
			if self.vehicle.lightsActive then
				self.vehicle:setLightsVisibility(false);
			else
				self.vehicle:setLightsVisibility(true);
			end;
		end;
	end;
	if self.event == "toggleFrontWorklights" then
		if self.vehicle ~= nil then
			local i = 1;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
	if self.event == "toggleBackWorklights" then
		if self.vehicle ~= nil then
			local i = 2;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
		if self.event == "togglePipeLights" then
		if self.vehicle ~= nil then
			local i = 3;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
		if self.event == "toggleIntoLights" then
		if self.vehicle ~= nil then
			local i = 4;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
	if self.event == "toggleWarningLights" then
		if self.vehicle ~= nil then
			if self.vehicle.B3.wl then
				self.vehicle:setState("warnlights", false);
				self.vehicle:setState("dirLeft", false);
				self.vehicle:setState("dirRight", false);
			else
				self.vehicle:setState("warnlights", true);
				self.vehicle:setState("dirLeft", true);
				self.vehicle:setState("dirRight", true);
			end;
		end;
	end;
	if self.event == "toggleRightIndicator" then
		if self.vehicle ~= nil then
			if not self.vehicle.B3.wl then
				if self.vehicle.B3.dirRight[1].a then
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", false);
				else
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", true);
				end;
			end;
		end;
	end;
	if self.event == "toggleLeftIndicator" then
		if self.vehicle ~= nil then
			if not self.vehicle.B3.wl then
				if self.vehicle.B3.dirLeft[1].a then
					self.vehicle:setState("dirLeft", false);
					self.vehicle:setState("dirRight", false);
				else
					self.vehicle:setState("dirLeft", true);
					self.vehicle:setState("dirRight", false);
				end;
			end;
		end;
	end;
        if self.event == "toggleStrawSpec" then
			if self.vehicle ~= nil then
		    self.vehicle:setStrawSpecActive(not self.vehicle.strawActive);
		end;
	end;
	
	if self.event == "toggleBeaconLights" then
		if self.vehicle ~= nil then
			self.vehicle:setBeaconLightsVisibility(not self.vehicle.beaconLightsActive);
		end;
	end;
	if self.event == "togglePipe" then
		if self.vehicle ~= nil then
			if forceAction == nil then
				local nextState = self.vehicle.targetPipeState+1;
				if nextState > self.vehicle.numPipeStates then
					nextState = 1;
				end;
				self.vehicle:setPipeState(nextState, true);
			end;
		end;
	end;
	if self.event == "toggleThreshing" then
		if self.vehicle ~= nil then
			self.vehicle:setIsThreshing(not self.vehicle.isThreshing);
		end;	
	end;
	--?????????
	if self.event == "toggleOpenGT" then
		if self.vehicle ~= nil then
			self.vehicle.OpenGT = not self.vehicle.OpenGT;
		end;	
	end;
	if self.event == "toggleModeMonitor" then
		if self.vehicle ~= nil then
		self.vehicle:setMonitorTool(self.vehicle.MonitorTool+1);
			if self.vehicle.MonitorTool > 4 then
			self.vehicle.MonitorTool = 0 ;
			end;
		end;
	end;
        if self.event == "toggleMotorIgnition" then
			if self.vehicle.isMotorStarted then
				self.vehicle:invokeIgnition(false, noEventSend);
			else
				self.vehicle:invokeIgnition(true, noEventSend);
		end;
	end;
		if self.vehicle ~= nil then
		if self.vehicle.ModalitiSTR then
	if self.event == "AutoLevel_OFF" then
			self.vehicle:setCurrentTool(M400_Advance.SELFLEVELOFF);
	elseif self.event == "ManualLevel_ON" then
			self.vehicle:setCurrentTool(M400_Advance.MANUALLEVEL);
	elseif self.event == "AutoLevel_ON" then
			self.vehicle:setCurrentTool(M400_Advance.SELFLEVELING);
			end;
		end;
	end;
		if self.vehicle ~= nil then
		if self.vehicle.EvenLModder then
	if self.event == "AutoLevel_OFF" then
			self.vehicle:setCurrentTool(M400_Advance.SELFLEVELOFF);
	elseif self.event == "Modalita_TRP" then
			self.vehicle:setCurrentTool(M400_Advance.STRADALEV);
			end;
		end;
	end;
		if self.vehicle ~= nil then
		if self.event == "AutoLevFR_OFF" then
			self.vehicle:setSelectTool("FrontLevOFF");
		elseif self.event == "ManualLevFR_ON" then
			self.vehicle:setSelectTool("FrontLevML");
		elseif self.event == "AutoLevFR_ON" then
			self.vehicle:setSelectTool("FrontLevAL");
		end;
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;