--
-- Body Computer Laverda M400Lci
--
-- by ***Gya***
--
-- IFF_Team( http://web.italianfarmers.net/ )

BPCAnim = {};

function BPCAnim.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BPCAnim:load(xmlFile)

	local lampscount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.lamps#count"), 0);
	self.lamps = {};
	if lampscount ~= 0 then
		for i=1, lampscount do
			local lampnumber = string.format("vehicle.lamps.lamp%d", i);	
			self.lamps[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, lampnumber .. "#index"));	
		end;	
	end;
	-- Luefter
	self.Luefter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BPCAnim#luefterIndex"));
	
	-- Temperaturzeiger / temperature Display animation
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BPCAnim.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.BPCAnim.TemperaturZeiger#maxRotation"));
	self.tempCnt = 0;

	-- Temperaturzeiger2 / temperature Display animation
	self.temperaturZeiger2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BPCAnim.TemperaturZeiger2#zeigerIndex"));
	self.temperaturZeigerMaxRot2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.BPCAnim.TemperaturZeiger2#maxRotation"));
	self.tempCnt2 = 0;

	-- Temperaturzeiger2 / temperature Display animation
	self.temperaturZeiger3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BPCAnim.TemperaturZeiger3#zeigerIndex"));
	self.temperaturZeigerMaxRot3 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.BPCAnim.TemperaturZeiger3#maxRotation"));
	self.tempCnt3 = 0;
	
		-- Digital Display digits LiftHeight
		
	self.numDigitLiftHeightOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitLiftHeightOne#count"), 0);
	self.digitLiftHeightOne = {};
    for i=1, self.numDigitLiftHeightOne do
        local objname = string.format("vehicle.displayDigitLiftHeightOne.digitLiftHeight" .. "%d", i);
		self.digitLiftHeightOne[i] = {};
        self.digitLiftHeightOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitLiftHeightOne[i].rotNode,false);
    end;
	setVisibility(self.digitLiftHeightOne[self.numDigitLiftHeightOne].rotNode,true);
	
	self.numDigitLiftHeightTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitLiftHeightTwo#count"), 0);
	self.digitLiftHeightTwo = {};
    for i=1, self.numDigitLiftHeightTwo do
        local objname = string.format("vehicle.displayDigitLiftHeightTwo.digitLiftHeight" .. "%d", i);
		self.digitLiftHeightTwo[i] = {};
        self.digitLiftHeightTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitLiftHeightTwo[i].rotNode,false);
    end;
	setVisibility(self.digitLiftHeightTwo[self.numDigitLiftHeightTwo].rotNode,true);

	
	self.prevousDigitLiftHeightTwo = self.numDigitLiftHeightTwo;
	self.prevousDigitLiftHeightOne = 0;
	
		-- Digital Display digits LiftHeight
		
	self.numDigitHeightOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitHeightOne#count"), 0);
	self.digitHeightOne = {};
    for i=1, self.numDigitHeightOne do
        local objname = string.format("vehicle.displayDigitHeightOne.digitLiftHeight" .. "%d", i);
		self.digitHeightOne[i] = {};
        self.digitHeightOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitHeightOne[i].rotNode,false);
    end;
	setVisibility(self.digitHeightOne[self.numDigitHeightOne].rotNode,true);
	
	self.numDigitHeightTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitHeightTwo#count"), 0);
	self.digitHeightTwo = {};
    for i=1, self.numDigitHeightTwo do
        local objname = string.format("vehicle.displayDigitHeightTwo.digitLiftHeight" .. "%d", i);
		self.digitHeightTwo[i] = {};
        self.digitHeightTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitHeightTwo[i].rotNode,false);
    end;
	setVisibility(self.digitHeightTwo[self.numDigitHeightTwo].rotNode,true);

	
	self.prevousDigitHeightTwo = self.numDigitHeightTwo;
	self.prevousDigitHeightOne = 0;
	
		-- Digital Display digits LiftHeight
		
	self.numDigitLiftOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitLiftOne#count"), 0);
	self.digitLiftOne = {};
    for i=1, self.numDigitLiftOne do
        local objname = string.format("vehicle.displayDigitLiftOne.digitLiftHeight" .. "%d", i);
		self.digitLiftOne[i] = {};
        self.digitLiftOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitLiftOne[i].rotNode,false);
    end;
	setVisibility(self.digitLiftOne[self.numDigitLiftHeightOne].rotNode,true);
	
	self.numDigitLiftTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitLiftTwo#count"), 0);
	self.digitLiftTwo = {};
    for i=1, self.numDigitLiftHeightTwo do
        local objname = string.format("vehicle.displayDigitLiftTwo.digitLiftHeight" .. "%d", i);
		self.digitLiftTwo[i] = {};
        self.digitLiftTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitLiftTwo[i].rotNode,false);
    end;
	setVisibility(self.digitLiftTwo[self.numDigitLiftHeightTwo].rotNode,true);

	
	self.prevousDigitLiftTwo = self.numDigitLiftTwo;
	self.prevousDigitLiftOne = 0;
	
end;

function BPCAnim:delete()
end;
function BPCAnim:mouseEvent(posX, posY, isDown, isUp, button)
end;
function BPCAnim:keyEvent(unicode, sym, modifier, isDown)
end;

function BPCAnim:updateTick(dt)
end;
function BPCAnim:update(dt)

	--Anim Inition Veicle
	
	if self.isMotorStarted then
		self:setAnimationTime(9, self.animationParts[9].animDuration, false); 
       else
		self:setAnimationTime(9, self.animationParts[9].offSet, false);
	end;
	
			-- Zapfwellenstummel / Powershaft rotation
			rotate(self.Luefter, 0,0,0.05*dt);
			
	if self:getIsActive() then
		if self.isMotorStarted then
			
			-- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt));
				self.tempCnt = self.tempCnt + 0.5;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt));
				self.tempCnt = math.min(self.tempCnt + 0.2, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt));
				self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
			end;
			if self.tempCnt2 < 3000 then
				setRotation(self.temperaturZeiger2, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2));
				self.tempCnt2 = self.tempCnt2 + 0.8;
			elseif self.tempCnt2 > 3000 and self.tempCnt2 < 6000 then
				setRotation(self.temperaturZeiger2, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2));
				self.tempCnt2 = math.min(self.tempCnt2 + 0.3, 10000);			
			else
				setRotation(self.temperaturZeiger2, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2));
				self.tempCnt2 = math.min(self.tempCnt2 + 0.04, 10000);
			end;
			if self.tempCnt3 < 3000 then
				setRotation(self.temperaturZeiger3, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot3/10000)*self.tempCnt3));
				self.tempCnt3 = self.tempCnt3 + 0.9;
			elseif self.tempCnt3 > 3000 and self.tempCnt3 < 6000 then
				setRotation(self.temperaturZeiger3, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot3/10000)*self.tempCnt3));
				self.tempCnt3 = math.min(self.tempCnt3 + 0.5, 10000);			
			else
				setRotation(self.temperaturZeiger3, 0, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot3/10000)*self.tempCnt3));
				self.tempCnt3 = math.min(self.tempCnt3 - 0.09, 10000);
			end;			
		end;
	else
		self.tempCnt = math.max(self.tempCnt - 0.08, 0);
		self.tempCnt2 = math.max(self.tempCnt2 - 0.2, 0);
		self.tempCnt3 = math.max(self.tempCnt3 - 0.5, 0);
	end;
	
	-- Digital Display Level Front
	
	if self.isEntered and self.lastRotation ~= nil then
		local displayValue = 0
		if self.isMotorStarted then
			displayValue = 10 - ((self.lastRotation/4.18)*180);
		else
			displayValue = -10;
		end;
		
		if self.isMotorStarted then
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			if self.prevousDigitLiftHeightTwo ~= tens then
				if self.prevousDigitLiftHeightTwo > 0 then
					setVisibility(self.digitLiftHeightTwo[self.prevousDigitLiftHeightTwo].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = self.numDigitLiftHeightTwo;
				end;
				setVisibility(self.digitLiftHeightTwo[displayIndex].rotNode,true);
			end;
			self.prevousDigitLiftHeightTwo = displayIndex;
			displayValue = displayValue - tens * 10;
			local ones = math.floor(displayValue);
			displayIndex = ones;
			if self.prevousDigitLiftHeightOne ~= ones then
				if self.prevousDigitLiftHeightOne > 0 then
					setVisibility(self.digitLiftHeightOne[self.prevousDigitLiftHeightOne].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = 10;
				end;
				setVisibility(self.digitLiftHeightOne[displayIndex].rotNode,true);
			end;
			self.prevousDigitLiftHeightOne = displayIndex;
			self.LiftHeightDisplaysSetOff = false;
		else
			if not self.LiftHeightDisplaysSetOff then
				for i=1, self.numDigitLiftHeightOne do
					setVisibility(self.digitLiftHeightOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitLiftHeightTwo do
					setVisibility(self.digitLiftHeightTwo[i].rotNode,false);
				end;
				
				self.LiftHeightDisplaysSetOff = true;
			end;
		end;
	end;	
	
	-- Digital Display Level Lateral
	
	if self.isEntered and self.lastXRotation ~= nil then
		local displayValue = 0
		if self.isMotorStarted then
			displayValue = 20 + ((self.lastXRotation/4.18)*180);
		else
			displayValue = 0 - ((self.lastXRotation/4.18)*-180);
		end;
		
		if self.isMotorStarted then
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			if self.prevousDigitHeightTwo ~= tens then
				if self.prevousDigitHeightTwo > 0 then
					setVisibility(self.digitHeightTwo[self.prevousDigitHeightTwo].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = self.numDigitHeightTwo;
				end;
				setVisibility(self.digitHeightTwo[displayIndex].rotNode,true);
			end;
			self.prevousDigitHeightTwo = displayIndex;
			displayValue = displayValue - tens * 10;
			local ones = math.floor(displayValue);
			displayIndex = ones;
			if self.prevousDigitHeightOne ~= ones then
				if self.prevousDigitHeightOne > 0 then
					setVisibility(self.digitHeightOne[self.prevousDigitHeightOne].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = 10;
				end;
				setVisibility(self.digitHeightOne[displayIndex].rotNode,true);
			end;
			self.prevousDigitHeightOne = displayIndex;
			self.HeightDisplaysSetOff = false;
		else
			if not self.HeightDisplaysSetOff then
				for i=1, self.numDigitHeightOne do
					setVisibility(self.digitHeightOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitHeightTwo do
					setVisibility(self.digitHeightTwo[i].rotNode,false);
				end;
				
				self.HeightDisplaysSetOff = true;
			end;
		end;
	end;

	-- Digital Display Level Joint
	
	if self.isEntered and self.lastZRotation ~= nil then
		local displayValue = 0
		if self.isMotorStarted then
			displayValue = 20 + ((self.lastZRotation/4.18)*180);
		else
			displayValue = 0 - ((self.lastZRotation/4.18)*-180);
		end;
		
		if self.isMotorStarted then
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			if self.prevousDigitLiftTwo ~= tens then
				if self.prevousDigitLiftTwo > 0 then
					setVisibility(self.digitLiftTwo[self.prevousDigitLiftTwo].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = self.numDigitLiftTwo;
				end;
				setVisibility(self.digitLiftTwo[displayIndex].rotNode,true);
			end;
			self.prevousDigitLiftTwo = displayIndex;
			displayValue = displayValue - tens * 10;
			local ones = math.floor(displayValue);
			displayIndex = ones;
			if self.prevousDigitLiftOne ~= ones then
				if self.prevousDigitLiftOne > 0 then
					setVisibility(self.digitLiftOne[self.prevousDigitLiftOne].rotNode,false);
				end;
				if displayIndex == 0 then
					displayIndex = 10;
				end;
				setVisibility(self.digitLiftOne[displayIndex].rotNode,true);
			end;
			self.prevousDigitLiftOne = displayIndex;
			self.LiftDisplaysSetOff = false;
		else
			if not self.LiftDisplaysSetOff then
				for i=1, self.numDigitLiftOne do
					setVisibility(self.digitLiftOne[i].rotNode,false);
				end;
		
				for i=1, self.numDigitLiftTwo do
					setVisibility(self.digitLiftTwo[i].rotNode,false);
				end;
				
				self.LiftDisplaysSetOff = true;
			end;
		end;
	end;	
end;

function BPCAnim:draw()
end;

function BPCAnim:onEnter()
end;
function BPCAnim:onLeave()
end;