--
-- whellParticle
-- Specialization for whellParticle
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		05/11/10
-- @version:	v2.1
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 and some bugfixes
--				v2.1 - Network-Fixes
--
wheelParticle = {};

function wheelParticle.prerequisitesPresent(specializations)
    return true;
end;

function wheelParticle:load(xmlFile)

	self.wheelParticleSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticleSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;
end;

function wheelParticle:delete()
	for i=1, table.getn(self.wheelParticleSystems) do
		Utils.deleteParticleSystem(self.wheelParticleSystems[i].particleSystems);
    end;
end;

function wheelParticle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelParticle:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelParticle:update(dt)
	
	local dens = 0; local dens1; local dens2; local dens3;
	local x,y,z = getWorldTranslation(self.wheels[2].repr);
	local x1,y1,z1 = getWorldTranslation(self.wheels[1].repr);
	local x2,y2,z2 = getWorldTranslation(self.wheels[4].repr);
	local id = g_currentMission.terrainDetailId;
	local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
	dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
	dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
	dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
		dens = dens1+dens2+dens3;
	end;
	if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
		for i=1, table.getn(self.wheelParticleSystems) do
			Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, self.wheels[i].hasGroundContact);
		end;
	else
		for i=1, table.getn(self.wheelParticleSystems) do
			Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
		end;
	end;
	
end;

function wheelParticle:draw()
end;