--
-- addMultiFruit
-- adds limited Multifruit capability to all vehicles
--
-- author: upsidedown
-- initial version: 03.09.2013
-- V0.9 PUBLIC BETA: 20.09.2013
-- V0.91/RC1: 20.10.2013 (several fixes, new fruits added)
-- V1.0: 21.10.2013 (added cutter/sowing differenciation)
-- V2.0: added modules
-- V2.1: 09.02.2014 added forageWagonConversionSources
-- V2.2: 18.08.2014 added support for MR parameters (realCapacityFx); 
-- V3.0_PUBLIC_BETA for LS15: load split into preLoad-load-postLoad, specialisation is sorting itself directly after fillable


addMultiFruit = {};
local addMultiFruit_directory = g_currentModDirectory;

function addMultiFruit.prerequisitesPresent(specializations)
	return true;
end;



--list of new fields:
-- -- -- threshingParticleSystems (cutter) NICHT FRUIT-INDEXED!
-- self.strawEffect.effectNodes
-- -- -- cutterTurnedOnScrollers  NICHT FRUIT-INDEXED!
-- cutterEffects (cutter)

-- function addMultiFruit:preLoad(xmlFile)
	-- print("preLoad")
	-- for fillType,desc in pairs(Fillable.fillTypeIndexToDesc) do
		-- local str = desc.hudOverlayFilename;
		-- if str ~= nil then
			
			-- local str2 = string.gsub(str, "//", "/");
			-- if str ~= str2 then
				-- print(str.." --> "..str2)
			-- end;
			-- desc.hudOverlayFilename = str2;
		-- end;
	-- end;
-- end;

function addMultiFruit:preLoad(xmlFile)

	local indexSelf
	local indexFillable
	for key,value in pairs(self.specializations) do
		if value == Fillable then
			indexFillable = key;
		elseif value == addMultiFruit then
			indexSelf = key;
		end;
	end;
	
	if indexSelf~= nil and indexFillable~= nil and indexSelf>indexFillable then
		table.remove(self.specializations,indexSelf)
		table.insert(self.specializations,indexFillable+1,addMultiFruit)
	end;	
end;

function addMultiFruit:load(xmlFile)
	-- --here add fillTypes
	-- if self.bodyTypes ~= nil then
		-- print("Multifruit:: This vehicle has changeBodyTypes specialization, no multi fruits added!")
		-- return;
	-- end;
	-- self.removeDoublePS = SpecializationUtil.callSpecializationsFunction("removeDoublePS");
	self.removeDoublePS = addMultiFruit.removeDoublePS;
	-- local newFillTypes = Utils.getNoNil(g_currentMission.addMultiFruitNewFillTypes,"");
	-- local substituteFillTypes;
	-- if self.preferedCombineSize ~= nil then --its a cutter
		-- substituteFillTypes = Utils.getNoNil(g_currentMission.addMultiFruitSubCutter,"");
		-- -- print("MF: cutter")
	-- elseif self.seeds~= nil then--its a sowingmachine
		-- substituteFillTypes = Utils.getNoNil(g_currentMission.addMultiFruitSubSowing,"");
		-- -- print("MF: sowing")
	-- else --its something else
		-- substituteFillTypes = Utils.getNoNil(g_currentMission.addMultiFruitSubStd,"");
		-- -- print("MF: something else")
	-- end;
	
	-- if self.fillTypes ~= nil then
		-- local types = Utils.splitString(" ",newFillTypes);
		-- local subTypes = Utils.splitString(" ",substituteFillTypes);
		-- for k,v in pairs(types) do

			-- local fillType = Fillable.fillTypeNameToInt[v];
			-- local subType_new = Fillable.fillTypeNameToInt[subTypes[k]];
			-- if fillType ~= nil and subType_new ~= nil then --filltype and subtype are installed
				
				-- if not self.fillTypes[fillType] and self.fillTypes[subType_new] then
					-- self.fillTypes[fillType] = true; --add fillType 
				-- end;
			-- end;
		-- end;
	-- end;	
end;


function addMultiFruit:postLoad(xmlFile)
	
	if self.bodyTypes ~= nil then
		-- print("Multifruit:: "..self.name.." has changeBodyTypes specialization, no multi fruits added!")
		return;
	end;

	
	local newFillTypes = Utils.getNoNil(g_currentMission.addMultiFruitNewFillTypes,"");
	local substituteFillTypes;
	if self.preferedCombineSize ~= nil then --its a cutter
		substituteFillTypes = Utils.getNoNil(g_currentMission.addMultiFruitSubCutter,"");
		-- print("MF: cutter")
	elseif self.seeds~= nil then--its a sowingmachine
		substituteFillTypes = Utils.getNoNil(g_currentMission.addMultiFruitSubSowing,"");
		-- print("MF: sowing")
	else --its something else
		substituteFillTypes = Utils.getNoNil(g_currentMission.addMultiFruitSubStd,"");
		-- print("MF: something else")
	end;

	
	
	
	if self.varBody~= nil then 
		if self.varBody.nodes ~= nil then
		
			for k,entry in pairs(self.varBody.nodes) do
				local types = Utils.splitString(" ",newFillTypes);
				local subTypes = Utils.splitString(" ",substituteFillTypes);
				for k,v in pairs(types) do
					local fillType = Fillable.fillTypeNameToInt[v];
					local subType_new = Fillable.fillTypeNameToInt[subTypes[k]];
					if fillType ~= nil and subType_new ~= nil then --filltype and subtype are installed in map 
						if not entry.fillTypes[fillType] and entry.fillTypes[subType_new] then
							entry.fillTypes[fillType] = true; --add fillType 
							if entry.fillPlanes ~= nil then --add fillPlanes
								local subFill = subTypes[k];

								if entry.fillPlanes[subFill] ~= nil and entry.fillPlanes[Fillable.fillTypeIntToName[fillType]] == nil then
									entry.fillPlanes[Fillable.fillTypeIntToName[fillType]] = entry.fillPlanes[subFill];
								end;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	
	if self.fillTypes ~= nil then
		local types = Utils.splitString(" ",newFillTypes);
		local subTypes = Utils.splitString(" ",substituteFillTypes);
		for k,v in pairs(types) do

			local fillType = Fillable.fillTypeNameToInt[v];
			local subType_new = Fillable.fillTypeNameToInt[subTypes[k]];
			if fillType ~= nil and subType_new ~= nil then --filltype and subtype are installed
				
				if not self.fillTypes[fillType] and self.fillTypes[subType_new] then
					self.fillTypes[fillType] = true; --add fillType 
					--print(v,"  ",subTypes[k])
					
					if self.tipAnimations ~= nil then
						for k,tip in pairs(self.tipAnimations) do
							if tip.tipEffectFillTypes~= nil then
								tip.tipEffectFillTypes[fillType] = tip.tipEffectFillTypes[subType_new]; --new in LS15
							end;
						end;
					end;
					
					if self.shovelEmptyEffectFillTypes~= nil then
						if self.shovelEmptyEffectFillTypes[fillType] == nil and self.shovelEmptyEffectFillTypes[subType_new] ~= nil then
							self.shovelEmptyEffectFillTypes[fillType] = self.shovelEmptyEffectFillTypes[subType_new];
						end;
					end;
										
					
					if self.fillPlanes ~= nil then --add fillPlanes
						local subFill = subTypes[k];
						if self.fillPlanes[subFill] ~= nil and self.fillPlanes[Fillable.fillTypeIntToName[fillType]] == nil then
							self.fillPlanes[Fillable.fillTypeIntToName[fillType]] = self.fillPlanes[subFill];
						end;					
					end;
					
					
					if self.tipAnimations ~= nil then --add tipAnimation Particle Systems						
						for kkk,tipAnimation in pairs(self.tipAnimations) do
							local sub = Fillable.fillTypeNameToInt[subTypes[k]]
						
							if tipAnimation.dischargeParticleSystems[sub] ~= nil and tipAnimation.dischargeParticleSystems[fillType]==nil then
								tipAnimation.dischargeParticleSystems[fillType] = tipAnimation.dischargeParticleSystems[sub];
								tipAnimation.dischargeParticleSystems[fillType].original = sub;						
							end;
						end;
					end;
					
					if self.isRealistic then
						if self.realCapacityFx ~= nil then
							if self.realCapacityFx[fillType] == nil and self.realCapacityFx[subType_new]~= nil then
								self.realCapacityFx[fillType] = self.realCapacityFx[subType_new];
								--print(self.name.."  "..tostring(fillType).." "..tostring(subType_new).." "..tostring(self.realCapacityFx[fillType]))
							end;
						end;					
					end;
							
					
					if self.baleTypes ~= nil then --add 
						
						local subFill = Fillable.fillTypeNameToInt[subTypes[k]];
						if self.baleTypes[subFill] ~= nil and self.baleTypes[fillType] == nil then
							self.baleTypes[fillType] = self.baleTypes[subFill];
						end;					
						-- for fillType, enabled in pairs(self.fillTypes) do --repeat the post-load of baler.lua
							-- if enabled and fillType ~= Fillable.FILLTYPE_UNKNOWN then
								-- if FruitUtil.fillTypeIsWindrow[fillType] then
									-- table.insert(self.balerPickupFillTypes, fillType);
								-- end
							-- end
						-- end					

					end;
					
					
					
					
					if self.emptyParticleSystems ~= nil then --add 
						local subFill = Fillable.fillTypeNameToInt[subTypes[k]];
						if self.emptyParticleSystems[subFill] ~= nil and self.emptyParticleSystems[fillType] == nil then
							self.emptyParticleSystems[fillType] = self.emptyParticleSystems[subFill];
							self.emptyParticleSystems[fillType].original = subFill;
						end;					
					end;
					
					if self.shovelFillParticleSystems ~= nil then --add 
						local subFill = Fillable.fillTypeNameToInt[subTypes[k]];
						if self.shovelFillParticleSystems[subFill] ~= nil and self.shovelFillParticleSystems[fillType] == nil then
							self.shovelFillParticleSystems[fillType] = self.shovelFillParticleSystems[subFill];
							self.shovelFillParticleSystems[fillType].original = subFill;
						end;					
					end;
					

				end;
				
				
			else --fruit is not installed in map
			   --print("Warning: '"..self.configFileName.. "' has invalid fillType (MF mod)'"..v.."'.");
			end;
			
			if true then
				local sub = string.upper(subTypes[k]);
				local new = string.upper(v);
				if Fillable["FILLTYPE_"..new] ~= nil then
					local str2Vec = {"_120_90_240", "_112_130"};
					for	_,str2 in pairs(str2Vec) do
						local subIndex = "BALETYPE_"..sub..str2;
						local newIndex = "BALETYPE_"..new..str2;
						if BaleUtil[subIndex] ~= nil and BaleUtil[newIndex] == nil then				
							BaleUtil[newIndex] = BaleUtil[subIndex];
							if BaleUtil.baleIndexToDesc[BaleUtil[subIndex]].isRoundbale then
								BaleUtil.roundBales[newIndex] = BaleUtil.baleIndexToDesc[BaleUtil[subIndex]];
							else
								BaleUtil.squareBales[newIndex] = BaleUtil.baleIndexToDesc[BaleUtil[subIndex]];
							end;
							print(('\\______ Bale registered: %s -> %s'):format(newIndex, subIndex));
						end;
					end;						
				end;
			end;
			
		end;
		
		
		
		
	end;
	
	--fruittypes for combines, cutters etc
	if true then
		local types = Utils.splitString(" ",newFillTypes);
		local subTypes = Utils.splitString(" ",substituteFillTypes);
		for k,v in pairs(types) do
			local descNew = FruitUtil.fruitTypes[v];
			local descSub = FruitUtil.fruitTypes[subTypes[k]];
			if descNew ~= nil and descSub ~= nil then
				
				if true then --forageWagonStuff
					local index_new = descNew.index;
					local index_sub = descSub.index;
					
					if descNew.hasWindrow then --haswindrow
						if FruitUtil.fruitIndexToDesc[index_new].forageWagonConversionTarget == nil then
							if descSub.name == "grass" then
								FruitUtil.registerFruitTypeWindrowForageWagonConversion(index_new, FruitUtil.FRUITTYPE_GRASS);
							else
								FruitUtil.registerFruitTypeWindrowForageWagonConversion(index_new, FruitUtil.FRUITTYPE_WHEAT);
							end;							
						end;
					end;				
				end;
				
				if self.pipeParticleSystems~= nil then
					if self.pipeParticleSystems[descSub.index] ~= nil and self.pipeParticleSystems[descNew.index] == nil then
						self.pipeParticleSystems[descNew.index] = self.pipeParticleSystems[descSub.index];
						self.pipeParticleSystems[descNew.index].original = descSub.index;
					end;
				end;
				
				if self.convertedFruits~= nil then
					if self.convertedFruits[descSub.index] ~= nil and self.convertedFruits[descNew.index] == nil then
						self.convertedFruits[descNew.index] = self.convertedFruits[descSub.index]
					end;
				end;
				
				if self.grainTankPlanes~= nil then
					if self.grainTankPlanes[subTypes[k]] ~= nil and self.grainTankPlanes[v] == nil then
						self.grainTankPlanes[v] = self.grainTankPlanes[subTypes[k]];
					end;
				end;
				
				if self.chopperParticleSystems~= nil then
					if self.chopperParticleSystems[descSub.index] ~= nil and self.chopperParticleSystems[descNew.index] == nil then
						self.chopperParticleSystems[descNew.index] = self.chopperParticleSystems[descSub.index];
						self.chopperParticleSystems[descNew.index].original = descSub.index;
					end;
				end;
				
				if self.strawParticleSystems~= nil then
					if self.strawParticleSystems[descSub.index] ~= nil and self.strawParticleSystems[descNew.index] == nil then
						self.strawParticleSystems[descNew.index] = self.strawParticleSystems[descSub.index];
						self.strawParticleSystems[descNew.index].original = descSub.index;
					end;
				end;
				
				
				if self.combineThreshingFillParticleSystems~= nil then
					if self.combineThreshingFillParticleSystems[descSub.index] ~= nil and self.combineThreshingFillParticleSystems[descNew.index] == nil then
						self.combineThreshingFillParticleSystems[descNew.index] = self.combineThreshingFillParticleSystems[descSub.index];
						self.combineThreshingFillParticleSystems[descNew.index].original = descSub.index;
					end;
				end;
				
				if self.grainTankFruitTypes~= nil then
					if self.grainTankFruitTypes[descSub.index] ~= nil and self.grainTankFruitTypes[descNew.index] == nil then
						self.grainTankFruitTypes[descNew.index] = self.grainTankFruitTypes[descSub.index];
					end;
				end;
				
				
				if self.fruitExtraObjects~= nil then
					if self.fruitExtraObjects[subTypes[k]] ~= nil and self.fruitExtraObjects[v] == nil then
						self.fruitExtraObjects[v] = self.fruitExtraObjects[subTypes[k]];
					end;
				end;
				
				
				if self.fruitTypes~= nil then
					if self.fruitTypes[descSub.index] ~= nil then
						if self.fruitTypes[descNew.index] == nil then
							self.fruitTypes[descNew.index] = self.fruitTypes[descSub.index];
						end;
					end;
				end;
				
				
				--sfm combine:
				if self.fruitParticle ~= nil then
					if self.fruitParticle.leftFreePart ~= nil then
						if self.fruitParticle.leftFreePart[descSub.name] ~= nil and self.fruitParticle.leftFreePart[descNew.name] == nil then
							self.fruitParticle.leftFreePart[descNew.name] = self.fruitParticle.leftFreePart[descSub.name];
						end;
					end;				
				end
				
				if self.fruitParticle ~= nil then
					if self.fruitParticle.rightFreePart ~= nil then
						if self.fruitParticle.rightFreePart[descSub.name] ~= nil and self.fruitParticle.rightFreePart[descNew.name] == nil then
							self.fruitParticle.rightFreePart[descNew.name] = self.fruitParticle.rightFreePart[descSub.name];
						end;
					end;				
				end
				
				
				if self.seeds ~= nil then
					if descSub.allowsSeeding then
						for _,sub in pairs(self.seeds) do
							if descSub.index == sub then
								table.insert(self.seeds, descNew.index);
							end;
						end;						
					end;
				end;				
			end;
		end;	
	end;
	
end;

function addMultiFruit:delete()
end;

function addMultiFruit:mouseEvent(posX, posY, isDown, isUp, button)
end;

function addMultiFruit:keyEvent(unicode, sym, modifier, isDown)
end;

function addMultiFruit:update(dt)
	
	
end;


function addMultiFruit:updateTick(dt)
	-- if self:getIsActiveForInput(true) then
		-- -- if self.getOverlayFillType then
		-- -- print(self:getOverlayFillType())
		-- -- end;
		-- -- print(g_currentMission.fillTypeOverlayFillType)
	-- end;
end;

function addMultiFruit:readStream(streamId, connection)

end;

function addMultiFruit:writeStream(streamId, connection)


end;

function addMultiFruit:draw()
	

end;




function addMultiFruit:preDelete()

	
	if self.tipAnimations ~= nil then	
		for k, tipAnimations in pairs(self.tipAnimations) do
			self:removeDoublePS(tipAnimations.dischargeParticleSystems)
		end;		
	end;

	
	self:removeDoublePS(self.emptyParticleSystems)
	self:removeDoublePS(self.shovelFillParticleSystems)
	self:removeDoublePS(self.pipeParticleSystems)
	self:removeDoublePS(self.chopperParticleSystems)
	self:removeDoublePS(self.strawParticleSystems)
	self:removeDoublePS(self.combineThreshingFillParticleSystems)	
end;


function addMultiFruit:removeDoublePS(PSlist)
	if PSlist ~= nil then
		for kk, particleSystem in pairs(PSlist) do
			if particleSystem.original~= nil then
				if particleSystem.original ~= kk then
					PSlist[kk] = nil
				end;
			end;
		end;
	end;
end;