--------------------------------------------------------------------------------------
-- MOD: Inspector
-- MOD Version: 2.4
-- MOD Author: edmund
-- MOD date: 26.1.2011
-- MOD update to v2.0: 3.11.2012
-- MOD update to v2.1: 25.11.2012
-- MOD update to v2.2: 30.10.2014 (same as 2.1 but modified to work with LS15, no new features)
-- MOD update to v2.3: 15.11.2014 (minor new features and improvements)
-- MOD update to v2.4: 23.11.2014 (changed position (adjusting to Info overlay), key bindings, font size, missing fillType displays)
--
-- Copyright (C) edmund --
--------------------------------------------------------------------------------------
Inspector = {}; function Inspector:loadMap(name) local aNameSearch = {"vehicle.name." .. g_languageShort, "vehicle.name.en", "vehicle.name", "vehicle#type"}; self.bDisplay = 1; self.bLongFormat = 0; self.nSubStringLength = 40; self.bDarkColor = 0; self.nDebugOutput = 0; if Steerable.load ~= nil then local orgSteerableLoad = Steerable.load Steerable.load = function(self,xmlFile) orgSteerableLoad(self,xmlFile) for nIndex,sXMLPath in pairs(aNameSearch) do self.name = getXMLString(xmlFile, sXMLPath); if self.name ~= nil then break; end; end; if self.name == nil then self.name = g_i18n:getText("UNKNOWN") end; end; end; if Attachable.load ~= nil then local orgAttachableLoad = Attachable.load Attachable.load = function(self,xmlFile) orgAttachableLoad(self,xmlFile) for nIndex,sXMLPath in pairs(aNameSearch) do self.name = getXMLString(xmlFile, sXMLPath); if self.name ~= nil then break; end; end; if self.name == nil then self.name = g_i18n:getText("UNKNOWN") end; end end; end; function Inspector:deleteMap() end; function Inspector:mouseEvent(posX, posY, isDown, isUp, button) end; function Inspector:keyEvent(unicode, sym, modifier, isDown) if isDown and sym == Input.KEY_up and bitAND(modifier, Input.MOD_CTRL) > 0 then if self.bDisplay == 0 then self.bDisplay = 1; else self.bDisplay = 0; end; end; if isDown and sym == Input.KEY_right and bitAND(modifier, Input.MOD_CTRL) > 0 then if self.bLongFormat == 0 then self.bLongFormat = 1; self.nSubStringLength = 40; else self.bLongFormat = 0; self.nSubStringLength = 25; end; end; if isDown and sym == Input.KEY_left and bitAND(modifier, Input.MOD_CTRL) > 0 then if self.bDarkColor == 0 then self.bDarkColor = 1; else self.bDarkColor = 0; end; end; end; function Inspector:update(dt) end; function Inspector:draw() if self.bDisplay == 0 then return true; end; if g_currentMission.ingameMap.isFullSize == true then return true; end; if Input.keyPressedState[308] then return true; else local fPosX = 0.015; local fPosY = 0.92 - g_currentMission.hudHelpContentOverlay.height; local fFontSize = 0.014; local fLineDist = fFontSize + 0.002; setTextAlignment(RenderText.ALIGN_LEFT); local nLine = 0; local nVehicles = table.getn(g_currentMission.steerables); if nVehicles > 0 then for i=1,nVehicles do local oVehicle = g_currentMission.steerables[i]; local sLineOutput = ""; setTextBold(false); if self.bDarkColor == 1 then setTextColor(0,0,0,1); else setTextColor(1,1,1,1); end; if oVehicle.showWaterWarning then sLineOutput = sLineOutput .. g_i18n:getText("filltype_water") .. "!!! "; end; if oVehicle.beaconLightsActive then sLineOutput = sLineOutput .. "!"; end; if oVehicle.isHired then sLineOutput = sLineOutput .. "*"; end; if sLineOutput ~= "" then sLineOutput = sLineOutput .. " "; end; if oVehicle.isControlled then if oVehicle.controllerName ~= nil then sLineOutput = sLineOutput .. string.sub(Utils.getNoNil(oVehicle.controllerName, g_i18n:getText("UNKNOWN")), 0, 15) .. " / "; end; if g_currentMission.controlledVehicle == oVehicle then setTextBold(true); end; end; sLineOutput = sLineOutput .. string.sub(oVehicle.name, 0, self.nSubStringLength) .. " "; local bVeryLowFuel = false; if oVehicle.fuelFillLevel ~= nil then local nFuelPercentage = oVehicle.fuelFillLevel / oVehicle.fuelCapacity * 100; if nFuelPercentage < 10 then sLineOutput = sLineOutput .. "@" .. round(nFuelPercentage) .. "% " .. g_i18n:getText("filltype_fuel") .. " "; if nFuelPercentage <= 4 then setTextColor(1,0,0,1); bVeryLowFuel = true; end; end; end; local bAttachementHasFill = false; for nIndex,oImplement in pairs(oVehicle.attachedImplements) do if oImplement ~= nil and oImplement.object ~= nil then local attachement1 = outputAttachement(oImplement, self.bLongFormat, self.nSubStringLength); if attachement1[1] == true then bAttachementHasFill = true; end; sLineOutput = sLineOutput .. attachement1[2]; for nIndex2,oImplement2 in pairs(oImplement.object.attachedImplements) do if oImplement2 ~= nil and oImplement2.object ~= nil then local attachement2 = outputAttachement(oImplement2, self.bLongFormat, self.nSubStringLength); if attachement2[1] == true then bAttachementHasFill = true; end; sLineOutput = sLineOutput .. attachement2[2]; end; end; end; end; local bHasGrainInTank = false; if oVehicle.capacity ~= nil and oVehicle.fillLevel ~= nil then if oVehicle.capacity > 0 and oVehicle.fillLevel > 0 then bHasGrainInTank = true; local nTankPercentage = getPercentage(oVehicle.capacity, oVehicle.fillLevel); if (nTankPercentage >= 1) then sLineOutput = sLineOutput .. "| " .. getFillType(oVehicle.currentFillType, oVehicle.typeName) .. "@" .. round(nTankPercentage) .. "% "; end; if nTankPercentage >= 80 then setTextColor(1,1,0,1); end; end; end; if bHasGrainInTank or oVehicle.isControlled or oVehicle.isHired or bAttachementHasFill or bVeryLowFuel then nLine = nLine + 1; renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, sLineOutput); end; end; end; setTextColor(1,1,1,1); local sSheepLineOutput = ""; setTextBold(false); local bSheepWarningWool = false; local bSheepWarningProductivity = false; local bSheepWarningFoodStock = false; if type(g_currentMission.husbandries.sheep) ~= nil then if g_currentMission.husbandries.sheep.totalNumAnimals > 0 then if g_currentMission.husbandries.sheep.currentPallet ~= nil then local nPalletFillPercentage = g_currentMission.husbandries.sheep.currentPallet.fillLevel / g_currentMission.husbandries.sheep.currentPallet.capacity * 100; if nPalletFillPercentage > 90 then bSheepWarningWool = true; setTextColor(1,1,0,1); sSheepLineOutput = sSheepLineOutput .. g_i18n:getText("wool") .. "@" .. round(nPalletFillPercentage) .. "% "; end; end; if g_currentMission.husbandries.sheep.productivity > 0 and g_currentMission.husbandries.sheep.productivity < 1 then bSheepWarningProductivity = true; sSheepLineOutput = sSheepLineOutput .. g_i18n:getText("Productivity") .. "@" .. round(g_currentMission.husbandries.sheep.productivity * 100) .. "% "; end; end; end; local sCowLineOutput = ""; local bCowWarningProductivity = false; if g_currentMission.husbandries.cow.totalNumAnimals > 0 then if g_currentMission.husbandries.cow.productivity > 0 and g_currentMission.husbandries.cow.productivity < 1 then bCowWarningProductivity = true; sCowLineOutput = sCowLineOutput .. g_i18n:getText("Productivity") .. "@" .. round(g_currentMission.husbandries.cow.productivity * 100) .. "% "; end; end; if bSheepWarningFoodStock or bSheepWarningProductivity or bSheepWarningWool or bCowWarningProductivity then nLine = nLine + 1; end; if bSheepWarningFoodStock or bSheepWarningProductivity or bSheepWarningWool then nLine = nLine + 1; sSheepLineOutput = g_i18n:getText("statisticView_sheep") .. ": " .. sSheepLineOutput; renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, sSheepLineOutput); end; if bCowWarningProductivity then nLine = nLine + 1; sCowLineOutput = g_i18n:getText("statisticView_cow") .. ": " .. sCowLineOutput; renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, sCowLineOutput); end; end; end; function outputAttachement(oImplement, bFormat, nMaxStringLength) local oImplementObject = oImplement.object; local nCapacity = 0; local nFillLevel = 0; local nFillType = 0; local nTankPercentage = 0; local sFillName = ''; local bAttachementHasFill = false; if oImplementObject.capacity ~= nil then nCapacity = oImplementObject.capacity; end; if oImplementObject.fillLevel ~= nil then nFillLevel = oImplementObject.fillLevel; end; if oImplementObject.currentFillType ~= nil then nFillType = oImplementObject.currentFillType; elseif oImplementObject.currentInputFruitType ~= nil then nFillType = oImplementObject.currentInputFruitType; end; if nFillLevel > 0 and nCapacity > 0 then bAttachementHasFill = true; nTankPercentage = getPercentage(nCapacity, nFillLevel); sFillName = getFillType(nFillType, oImplementObject.typeName); if oImplementObject.currentSeed ~= nil then if table.getn(oImplementObject.seeds) > 1 then sFillName = sFillName .. ":" .. getFillType(oImplementObject.seeds[oImplementObject.currentSeed], oImplementObject.typeName); end; end; end; local sTempOutput = ''; if bFormat == 1 then if bAttachementHasFill then sTempOutput = sTempOutput .. "| " .. string.sub(oImplementObject.name, 0, nMaxStringLength) .. " " .. sFillName .. "@" .. round(nTankPercentage) .. "% "; else sTempOutput = sTempOutput .. "| " .. string.sub(oImplementObject.name, 0, nMaxStringLength) .. " "; end; else if bAttachementHasFill then sTempOutput = sTempOutput .. "| " .. sFillName .. "@" .. round(nTankPercentage) .. "% "; end; end; return {bAttachementHasFill, sTempOutput}; end; function getFillType(fillType, implementTypeName) local sFillType = g_i18n:getText("UNKNOWN"); if (implementTypeName == 'forageWagon' or implementTypeName == 'mixerWagon' or implementTypeName == 'selfPropelledMixerWagon') and (fillType == 11 or fillType == 10) then return g_i18n:getText("straw"); end; if implementTypeName == 'treePlanter' then return g_i18n:getText("helpMessageTitle16"); end; if implementTypeName == 'baleLoader' or implementTypeName == 'baleWrapper' or implementTypeName == 'baler' then return (g_i18n:getText("unit_bale"):gsub("^%l", string.upper)); end; if fillType == 16 then return g_i18n:getText("filltype_water"); end; if fillType == 17 then return g_i18n:getText("filltype_seeds"); end; if fillType == 20 then return g_i18n:getText("silage"); end; if fillType == 21 then return g_i18n:getText("forage_mixing"); end; if fillType == 22 then return g_i18n:getText("forage_mixing") end; if fillType == 23 then return g_i18n:getText("filltype_fertilizer"); end; if fillType == 24 then return g_i18n:getText("woodChips"); end; if fillType == 25 then return g_i18n:getText("filltype_fertilizer"); end; if fillType == 26 then return g_i18n:getText("filltype_manure"); end; if fillType == 27 then return g_i18n:getText("filltype_liquidManure"); end; if fillType == 28 then return g_i18n:getText("filltype_kalk"); end; if Utils.getNoNil(fillType, 0) > 0 then local nFruitType = FruitUtil.fillTypeToFruitType[fillType]; if nFruitType ~= nil then local sFruitDesc = FruitUtil.fruitIndexToDesc[nFruitType].name; if g_i18n:hasText(sFruitDesc) then sFillType = g_i18n:getText(sFruitDesc); end; end; end; return sFillType; end; function round(num, idp) if Utils.getNoNil(num, 0) > 0 then local mult = 10^(idp or 0); return math.floor(num * mult + 0.5) / mult; else return 0; end; end; function getPercentage(capacity, level) return level / capacity * 100; end; addModEventListener(Inspector);