--
--SearchModsScript = {}
--
--to search Mods, like MapDoorTrigger, MapBuyableObject, MapSuperSiloTrigger usw.
-- 
-- Include into the map moddesc.xml / Einbinden in die Map moddesc.xml 
-- 				between				/ 			zwischen
--	<modDesc descVersion="23"> 			and 			</modDesc>
--
--	<extraSourceFiles>
--		<sourceFile filename="SearchModsScript.lua" />
--	</extraSourceFiles>
--
--    <l10n>
--		<text name="SearchModsTitle">
--			<en>One or more mods missing</en>
--			<de>Fehlen eines/mehrerer Mods zur vollen Funktionalität der Map</de>
--		</text>
--		<text name="SearchModsInfoText">
--			<en>You are missing one or more mods to get the full functionality of the map. This can lead to both loss of the map's functionality and error messages in the log file. When closing the savegame, the list of missing mods will be printed to the log file.</en>
--			<de>Ihnen fehlen ein oder mehrere Mods um die volle Funktionalität der Map zu nutzen. Die kann dazu führen das Sie nicht alle Funktionen nutzen können, oder auch dazu dass Sie Fehlermeldungen in der LOG haben. Wenn sie das Spiel beenden dann stehen am Ende der LOG Datei die Mods die fehlen.</de>
--		</text>
--		<text name="SearchModsMissingTitle">
--			<en>Missing Mods:</en>
--			<de>Fehlende Mods:</de>
--		</text>
--		<text name="SearchModsDownloadTitle">
--			<en>Please download the following mods for full functionality of the map.</en>
--			<de>Bitte lade dir folgende Mods zur vollen Funktionalität der Map runter.</de>
--		</text>
--		<text name="SearchModsDownloadOptionalTitle">
--			<en>Optional mods:</en>
--			<de>Optionale Mods sind folgende:</de>
--		</text>
--	</l10n>
--
--	<SearchMods>
--		<mod zipName="ModName" downloadLink = "optional"/>		<!--Show Warning at Game Start and print a text in LOG file, Mods which absolut need/-->
--		<optionalMod zipName="Modname" downloadLink = "optional"/>	<!--Only Print the modname in LOG file at ending the Game/-->
--	</SearchMods>
--
--Only the Name of Mod, without ".zip"

--@date: 05/05/2014
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0	for fantasy Reloaded by tommy r
--			v1.1	optional mods, no warning at Game start for this mods, only text in Log File at ending the game
--			v2.0 convert to FS15 
--			v3.0 GUI, Thanks to JakobT
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission



SearchModsScript = {}
SearchModsScript_dir = g_currentModDirectory;

function SearchModsScript:loadMap(name)

	self.nameBase = g_currentMission.missionInfo.baseDirectory;
	if self.nameBase ~= SearchModsScript_dir then
		-- different map loaded
		return;
	end;
	self.searchModFailed = false;
	self.showFailedModsMessage = false;
	print("   SearchModsScript v3.0  by Bluebaby210 loaded!");

	local xml = loadXMLFile("modDesc", g_currentMission.missionInfo.baseDirectory.."modDesc.xml");

	-- MANDATORY MODS
	self.neededMods = {};
	self.downloadLink = {};
	local k = 0;
	while true do
		local linesname = string.format("modDesc.SearchMods.mod(%d)", k);
		if not hasXMLProperty(xml, linesname) then
			break;
		end;
		k = k + 1;
		self.neededMods[k] = getXMLString(xml, linesname .."#zipName");
		if getXMLString(xml, linesname .."#downloadLink") ~= nil then
			self.downloadLink[k] = getXMLString(xml, linesname .."#downloadLink");
		end;
		if self.neededMods[k] == "MapBuyableObject" then
			--print("	Match: MapBuyableObject");
			self.downloadLink[k] = "https://mod-portal.com/forum/filebase/index.php/Entry/555-Map-Buyable-Object/";
		end;
		--print(self.neededMods[k]);
	end;

	-- OPTIONAL MODS
	self.optionalMods = {};
	self.downloadLinkOptionalMod = {};
	local a = 0;
	while true do
		local linesname = string.format("modDesc.SearchMods.optionalMod(%d)", a);
		if not hasXMLProperty(xml, linesname) then
			break;
		end;
		a = a + 1;
		self.optionalMods[a] = getXMLString(xml, linesname .."#zipName");
		if getXMLString(xml, linesname .."#downloadLink") ~= nil then
			self.downloadLinkOptionalMod[a] = getXMLString(xml, linesname .."#downloadLink");
		end;
		--print(self.optionalMods[a]);
	end;


	-- FAILED OPTIONAL MODS
	self.failedOptionalMods = {};
	if #self.optionalMods >= 1 then
		for c=1, #self.optionalMods do
			local optionalModName = g_modsDirectory.."/"..self.optionalMods[c]..".zip";
			if not fileExists(optionalModName) then
				table.insert(self.failedOptionalMods, self.optionalMods[c]);
			end;
		end;
	end;


	-- FAILED MANDATORY MODS
	self.failedMods = {};
	if #self.neededMods >= 1 then
		for i=1, #self.neededMods do
			local modName = g_modsDirectory.."/"..self.neededMods[i]..".zip";
			if not fileExists(modName) then
				table.insert(self.failedMods, self.neededMods[i]);
				--print("			Not existed Mod: ", tostring(self.neededMods[i]));
				self.searchModFailed = true;
				self.showFailedModsMessage = true;
			end;
		end;
	end;

	if self.showFailedModsMessage and self.searchModFailed then
		self.addMissingModsMessage = true;
	end;
end;

function SearchModsScript:deleteMap()
	-- PRINT MISSING MANDATORY MODS
	if self.failedMods ~= nil and #self.failedMods >= 1 then
		print(" ")
		print(g_i18n:getText('SearchModsDownloadTitle'));
		for a=1, #self.failedMods do
			for i=1, #self.neededMods do
				if self.failedMods[a] == self.neededMods[i] then
					if self.downloadLink[i] ~= nil then
						print(self.neededMods[i].." : "..self.downloadLink[i]);
					else
						print(self.neededMods[i]..".zip");
					end;
				end;
			end;
		end;
	end;

	-- PRINT MISSING OPTIONAL MODS
	if self.failedOptionalMods ~= nil and #self.failedOptionalMods >= 1 then
		print(" ")
		print(g_i18n:getText('SearchModsDownloadOptionalTitle'));
		for c=1, #self.failedOptionalMods do
			for k=1, #self.optionalMods do
				if self.failedOptionalMods[c] == self.optionalMods[k] then
					if self.downloadLinkOptionalMod[k] ~= nil then
						print(self.optionalMods[k].." : "..self.downloadLinkOptionalMod[k]);
					else
						print(self.optionalMods[k]..".zip");
					end;
				end;
			end;
		end;
	end;
end;

function SearchModsScript:update(dt)
	if g_currentMission.paused or g_gui.currentGui ~= nil then
		return;
	end;

	if self.addMissingModsMessage then
		local msgTitle = g_i18n:getText('SearchModsTitle');
		local msgTxt = ('%s\n\n%s\n    %s'):format(g_i18n:getText('SearchModsInfoText'), g_i18n:getText('SearchModsMissingTitle'), table.concat(self.failedMods, '\n    '));

		g_currentMission.inGameMessage:showMessage(msgTitle, msgTxt, 900000, false);

		self.addMissingModsMessage = false;
	end;
end;

function SearchModsScript:draw() end;
function SearchModsScript:mouseEvent(posX, posY, isDown, isUp, button) end;
function SearchModsScript:keyEvent(unicode, sym, modifier, isDown) end;
function SearchModsScript:readStream(streamId, connection) end;
function SearchModsScript:writeStream(streamId, connection) end;

addModEventListener(SearchModsScript);