--
-- LS09Map
--
-- @author  Stefan Geiger
-- @date  12/07/10
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

LS09Map = {}

local LS09Map_mt = Class(LS09Map, Mission00);


function LS09Map:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = LS09Map_mt;
	end;
		local additionalFruitTypesPath = Utils.getFilename('scripts/AdditionalFruitTypes.lua', baseDirectory);
	print("loading AdditionalFruitTypes")
	if fileExists(additionalFruitTypesPath) then
	source(additionalFruitTypesPath);
	AdditionalFruitTypes:run(baseDirectory);
	else
	print("AdditionalFruitTypes.lua not found!")
    end;
    local self = LS09Map:superClass():new(baseDirectory, mt);

    return self;
end;

function LS09Map:delete()
    LS09Map:superClass().delete(self);
end;

function LS09Map:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/LS09Map.i3d", self.baseDirectory), true, self.loadCareerMap01Finished, self);
end;

function LS09Map:loadCareerMap01Finished(node, arguments)
    if self.cancelLoading then
        return;
    end
    local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("LS09Map.xml", self.baseDirectory));
    trcScreenFlip();
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
	trcScreenFlip();
    self.ingameMap:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    -- ATMs
    --self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), 180, -790, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), -192.5, -190, nil, nil, false, false, false, 0, true);

    -- shops
    self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), -513.654, -277.318, nil, nil, false, false, false, 0, true);
    local gardenCenterHotspot = self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), 417.158, -748.528, nil, nil, false, false, true, 0, true);
    gardenCenterHotspot.fullViewName = g_i18n:getText("gardenCenter");

    -- egg sellpoints
    self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), -13.249, -846.106, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), -741.5, -187, nil, nil, false, false, false, 0, true);
    
    -- farm silos
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 170.794, 208.475, nil, nil, false, false, false, 0, true);
    
    -- bga
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 9.848, 26.342, nil, nil, false, false, false, 0, true);
    
    -- grass heaps
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 438.042, -739.884, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -730.5, 140, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -144.5, 264.5, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -297, -595.5, nil, nil, false, false, false, 0, true);
    
    -- livestock
    self.ingameMap:createMapHotspot("Cows", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_cows.png", self.baseDirectory), 671.325, 208.942, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Sheep", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_sheep.png", self.baseDirectory), 665.997, 269.091, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Chickens", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_chickens.png", self.baseDirectory), 204.53, 97.645, nil, nil, false, false, false, 0, true);
    
    -- spinnery
    self.ingameMap:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_spinnery.png", self.baseDirectory), -14.242, -822.269, nil, nil, false, false, false, 0, true);

	trcScreenFlip();
    LS09Map:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
end;

function LS09Map:onStartMission()
    LS09Map:superClass().onStartMission(self);
end;

function LS09Map:mouseEvent(posX, posY, isDown, isUp, button)
    LS09Map:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function LS09Map:keyEvent(unicode, sym, modifier, isDown)
    LS09Map:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function LS09Map:update(dt)
    LS09Map:superClass().update(self, dt);
end;

function LS09Map:draw()
    LS09Map:superClass().draw(self);
end;
