

MixFeederUpdateFeederPlanes = {};
MixFeederUpdateFeederPlanes_mt = Class(MixFeederUpdateFeederPlanes, Event);
InitEventClass(MixFeederUpdateFeederPlanes, "MixFeederUpdateFeederPlanes");

function MixFeederUpdateFeederPlanes:emptyNew()
	local self = Event:new(MixFeederUpdateFeederPlanes_mt);
	self.className="MixFeederUpdateFeederPlanes";
	return self;
end;

function MixFeederUpdateFeederPlanes:new(object, fillType, fillLevel)
	local self = MixFeederUpdateFeederPlanes:emptyNew();
	self.object = object;
	self.fillType = fillType;
	self.fillLevel = fillLevel;
	return self;
end;

function MixFeederUpdateFeederPlanes:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.fillType);
	streamWriteFloat32(streamId, self.fillLevel);
end;

function MixFeederUpdateFeederPlanes:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.fillType  = streamReadString(streamId);
	self.fillLevel = streamReadFloat32(streamId);
	self:run(connection);
end;

function MixFeederUpdateFeederPlanes:run(connection)
	self.object:updateFeederPlanes(self.fillType, self.fillLevel, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederUpdateFeederPlanes:new(self.object, self.fillType, self.fillLevel), nil, connection, self.object);
	end;  
end;

function MixFeederUpdateFeederPlanes.sendEvent(object, fillType, fillLevel, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederUpdateFeederPlanes:new(object, fillType, fillLevel), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederUpdateFeederPlanes:new(object, fillType, fillLevel));
		end;
	end;
end;
