

MixFeederUpdateBunkerPlanes = {};
MixFeederUpdateBunkerPlanes_mt = Class(MixFeederUpdateBunkerPlanes, Event);
InitEventClass(MixFeederUpdateBunkerPlanes, "MixFeederUpdateBunkerPlanes");

function MixFeederUpdateBunkerPlanes:emptyNew()
	local self = Event:new(MixFeederUpdateBunkerPlanes_mt);
	self.className="MixFeederUpdateBunkerPlanes";
	return self;
end;

function MixFeederUpdateBunkerPlanes:new(object, fillType, fillLevel)
	local self = MixFeederUpdateBunkerPlanes:emptyNew();
	self.object = object;
	self.fillType = fillType;
	self.fillLevel = fillLevel;
	return self;
end;

function MixFeederUpdateBunkerPlanes:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.fillType);
	streamWriteFloat32(streamId, self.fillLevel);
end;

function MixFeederUpdateBunkerPlanes:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.fillType  = streamReadString(streamId);
	self.fillLevel = streamReadFloat32(streamId);
	self:run(connection);
end;

function MixFeederUpdateBunkerPlanes:run(connection)
	self.object:updateBunkerPlanes(self.fillType, self.fillLevel, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederUpdateBunkerPlanes:new(self.object, self.fillType, self.fillLevel), nil, connection, self.object);
	end;  
end;

function MixFeederUpdateBunkerPlanes.sendEvent(object, fillType, fillLevel, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederUpdateBunkerPlanes:new(object, fillType, fillLevel), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederUpdateBunkerPlanes:new(object, fillType, fillLevel));
		end;
	end;
end;
