

MixFeederStopFillFeeder = {};
MixFeederStopFillFeeder_mt = Class(MixFeederStopFillFeeder, Event);
InitEventClass(MixFeederStopFillFeeder, "MixFeederStopFillFeeder");

function MixFeederStopFillFeeder:emptyNew()
	local self = Event:new(MixFeederStopFillFeeder_mt);
	self.className="MixFeederStopFillFeeder";
	return self;
end;

function MixFeederStopFillFeeder:new(object, a)
	local self = MixFeederStopFillFeeder:emptyNew();
	self.object = object;
	self.a = a;
	return self;
end;

function MixFeederStopFillFeeder:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.a);
end;

function MixFeederStopFillFeeder:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.a  = streamReadInt8(streamId);
	self:run(connection);
end;

function MixFeederStopFillFeeder:run(connection)
	self.object:stopFillFeeder(self.a, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederStopFillFeeder:new(self.object, self.a), nil, connection, self.object);
	end;  
end;

function MixFeederStopFillFeeder.sendEvent(object, a, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederStopFillFeeder:new(object, a), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederStopFillFeeder:new(object, a));
		end;
	end;
end;
