

MixFeederStartFillFeeder = {};
MixFeederStartFillFeeder_mt = Class(MixFeederStartFillFeeder, Event);
InitEventClass(MixFeederStartFillFeeder, "MixFeederStartFillFeeder");

function MixFeederStartFillFeeder:emptyNew()
	local self = Event:new(MixFeederStartFillFeeder_mt);
	self.className="MixFeederStartFillFeeder";
	return self;
end;

function MixFeederStartFillFeeder:new(object, a)
	local self = MixFeederStartFillFeeder:emptyNew();
	self.object = object;
	self.a = a;
	return self;
end;

function MixFeederStartFillFeeder:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.a);
end;

function MixFeederStartFillFeeder:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.a  = streamReadInt8(streamId);
	self:run(connection);
end;

function MixFeederStartFillFeeder:run(connection)
	self.object:startFillFeeder(self.a, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederStartFillFeeder:new(self.object, self.a), nil, connection, self.object);
	end;  
end;

function MixFeederStartFillFeeder.sendEvent(object, a, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederStartFillFeeder:new(object, a), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederStartFillFeeder:new(object, a));
		end;
	end;
end;
