

MixFeederSetTypeFillLevelFeeder = {};
MixFeederSetTypeFillLevelFeeder_mt = Class(MixFeederSetTypeFillLevelFeeder, Event);
InitEventClass(MixFeederSetTypeFillLevelFeeder, "MixFeederSetTypeFillLevelFeeder");

function MixFeederSetTypeFillLevelFeeder:emptyNew()
	local self = Event:new(MixFeederSetTypeFillLevelFeeder_mt);
	self.className="MixFeederSetTypeFillLevelFeeder";
	return self;
end;

function MixFeederSetTypeFillLevelFeeder:new(object, fillType, feederFillLevel)
	local self = MixFeederSetTypeFillLevelFeeder:emptyNew();
	self.object = object;
	self.fillType = fillType;
	self.feederFillLevel = feederFillLevel;
	return self;
end;

function MixFeederSetTypeFillLevelFeeder:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.fillType);
	streamWriteFloat32(streamId, self.feederFillLevel);
end;

function MixFeederSetTypeFillLevelFeeder:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.fillType  = streamReadString(streamId);
	self.feederFillLevel = streamReadFloat32(streamId);
	self:run(connection);
end;

function MixFeederSetTypeFillLevelFeeder:run(connection)
	self.object:setTypeFillLevelFeeder(self.fillType, self.feederFillLevel, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederSetTypeFillLevelFeeder:new(self.object, self.fillType, self.feederFillLevel), nil, connection, self.object);
	end;  
end;

function MixFeederSetTypeFillLevelFeeder.sendEvent(object, fillType, feederFillLevel, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetTypeFillLevelFeeder:new(object, fillType, feederFillLevel), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetTypeFillLevelFeeder:new(object, fillType, feederFillLevel));
		end;
	end;
end;
