

MixFeederSetSplineTimeEvent = {};
MixFeederSetSplineTimeEvent_mt = Class(MixFeederSetSplineTimeEvent, Event);
InitEventClass(MixFeederSetSplineTimeEvent, "MixFeederSetSplineTimeEvent");

function MixFeederSetSplineTimeEvent:emptyNew()
	local self = Event:new(MixFeederSetSplineTimeEvent_mt);
	self.className="MixFeederSetSplineTimeEvent";
	return self;
end;

function MixFeederSetSplineTimeEvent:new(object, splTime, speed)
	local self = MixFeederSetSplineTimeEvent:emptyNew();
	self.object = object;
	self.splTime = splTime;
	self.speed = speed;
	return self;
end;

function MixFeederSetSplineTimeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.splTime);
	streamWriteFloat32(streamId, self.speed);
end;

function MixFeederSetSplineTimeEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.splTime  = streamReadFloat32(streamId);
	self.speed  = streamReadFloat32(streamId);
	self:run(connection);
end;

function MixFeederSetSplineTimeEvent:run(connection)
	self.object:setSplineTime(self.splTime, self.speed,true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederSetSplineTimeEvent:new(self.object, self.splTime, self.speed), nil, connection, self.object);
	end;  
end;

function MixFeederSetSplineTimeEvent.sendEvent(object, splTime, speed, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetSplineTimeEvent:new(object, splTime, speed), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetSplineTimeEvent:new(object, splTime, speed));
		end;
	end;
end;
