

MixFeederSetServiceTime = {};
MixFeederSetServiceTime_mt = Class(MixFeederSetServiceTime, Event);
InitEventClass(MixFeederSetServiceTime, "MixFeederSetServiceTime");

function MixFeederSetServiceTime:emptyNew()
	local self = Event:new(MixFeederSetServiceTime_mt);
	self.className = "MixFeederSetServiceTime";
	return self;
end;

function MixFeederSetServiceTime:new(object, service)
	local self = MixFeederSetServiceTime:emptyNew()
	self.object = object;
	self.service = service;
	return self;
end;

function MixFeederSetServiceTime:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.service);
end;

function MixFeederSetServiceTime:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.service  = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederSetServiceTime:run(connection)
	self.object:setServiceTime(self.service, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MixFeederSetServiceTime:new(self.object, self.service), nil, connection, self.object);
	end;
end;

function MixFeederSetServiceTime.sendEvent(object, service, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetServiceTime:new(object, service), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetServiceTime:new(object, service));
		end;
	end;
end;

