

MixFeederSetNewServiceTime = {};
MixFeederSetNewServiceTime_mt = Class(MixFeederSetNewServiceTime, Event);
InitEventClass(MixFeederSetNewServiceTime, "MixFeederSetNewServiceTime");

function MixFeederSetNewServiceTime:emptyNew()
	local self = Event:new(MixFeederSetNewServiceTime_mt);
	self.className="MixFeederSetNewServiceTime";
	return self;
end;

function MixFeederSetNewServiceTime:new(object, randomService)
	local self = MixFeederSetNewServiceTime:emptyNew();
	self.object = object;
	self.randomService = randomService;
	return self;
end;

function MixFeederSetNewServiceTime:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt16(streamId, self.randomService);
end;

function MixFeederSetNewServiceTime:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.randomService  = streamReadInt16(streamId);
	self:run(connection);
end;

function MixFeederSetNewServiceTime:run(connection)
	self.object:setNewServiceTime(self.randomService, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederSetNewServiceTime:new(self.object, self.randomService), nil, connection, self.object);
	end;  
end;

function MixFeederSetNewServiceTime.sendEvent(object, randomService, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetNewServiceTime:new(object, randomService), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetNewServiceTime:new(object, randomService));
		end;
	end;
end;
