

MixFeederManuelStart = {};
MixFeederManuelStart_mt = Class(MixFeederManuelStart, Event);
InitEventClass(MixFeederManuelStart, "MixFeederManuelStart");

function MixFeederManuelStart:emptyNew()
	local self = Event:new(MixFeederManuelStart_mt);
	self.className = "MixFeederManuelStart";
	return self;
end;

function MixFeederManuelStart:new(object, start)
	local self = MixFeederManuelStart:emptyNew()
	self.object = object;
	self.start = start;
	return self;
end;

function MixFeederManuelStart:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.start);
end;

function MixFeederManuelStart:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.start  = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederManuelStart:run(connection)
	self.object:manuelStart(self.start, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MixFeederManuelStart:new(self.object, self.start), nil, connection, self.object);
	end;
end;

function MixFeederManuelStart.sendEvent(object, start, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederManuelStart:new(object, start), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederManuelStart:new(object, start));
		end;
	end;
end;

