

MixFeederLastNumAnimalsFeed = {};
MixFeederLastNumAnimalsFeed_mt = Class(MixFeederLastNumAnimalsFeed, Event);
InitEventClass(MixFeederLastNumAnimalsFeed, "MixFeederLastNumAnimalsFeed");

function MixFeederLastNumAnimalsFeed:emptyNew()
	local self = Event:new(MixFeederLastNumAnimalsFeed_mt);
	self.className="MixFeederLastNumAnimalsFeed";
	return self;
end;

function MixFeederLastNumAnimalsFeed:new(object, numLastAnimal)
	local self = MixFeederLastNumAnimalsFeed:emptyNew();
	self.object = object;
	self.numLastAnimal = numLastAnimal;
	return self;
end;

function MixFeederLastNumAnimalsFeed:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt16(streamId, self.numLastAnimal);
end;

function MixFeederLastNumAnimalsFeed:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.numLastAnimal  = streamReadInt16(streamId);
	self:run(connection);
end;

function MixFeederLastNumAnimalsFeed:run(connection)
	self.object:lastNumAnimalsFeed(self.numLastAnimal, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederLastNumAnimalsFeed:new(self.object, self.numLastAnimal), nil, connection, self.object);
	end;  
end;

function MixFeederLastNumAnimalsFeed.sendEvent(object, numLastAnimal, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederLastNumAnimalsFeed:new(object, numLastAnimal), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederLastNumAnimalsFeed:new(object, numLastAnimal));
		end;
	end;
end;
