

MixFeederDischargePS = {};
MixFeederDischargePS_mt = Class(MixFeederDischargePS, Event);
InitEventClass(MixFeederDischargePS, "MixFeederDischargePS");

function MixFeederDischargePS:emptyNew()
	local self = Event:new(MixFeederDischargePS_mt);
	self.className = "MixFeederDischargePS";
	return self;
end;

function MixFeederDischargePS:new(object, active)
	local self = MixFeederDischargePS:emptyNew()
	self.object = object;
	self.active = active;
	return self;
end;

function MixFeederDischargePS:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.active);
end;

function MixFeederDischargePS:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.active  = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederDischargePS:run(connection)
	self.object:dischargePS(self.active, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MixFeederDischargePS:new(self.object, self.active), nil, connection, self.object);
	end;
end;

function MixFeederDischargePS.sendEvent(object, active, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederDischargePS:new(object, active), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederDischargePS:new(object, active));
		end;
	end;
end;

