
MixFeederChangeFeedingsPerDay = {};
MixFeederChangeFeedingsPerDay_mt = Class(MixFeederChangeFeedingsPerDay, Event);
InitEventClass(MixFeederChangeFeedingsPerDay, "MixFeederChangeFeedingsPerDay");

function MixFeederChangeFeedingsPerDay:emptyNew()
	local self = Event:new(MixFeederChangeFeedingsPerDay_mt);
	self.className="MixFeederChangeFeedingsPerDay";
	return self;
end;

function MixFeederChangeFeedingsPerDay:new(object, feedingsPerDay)
	local self = MixFeederChangeFeedingsPerDay:emptyNew();
	self.object = object;
	self.feedingsPerDay = feedingsPerDay;
	return self;
end;

function MixFeederChangeFeedingsPerDay:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.feedingsPerDay);
end;

function MixFeederChangeFeedingsPerDay:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.feedingsPerDay  = streamReadInt8(streamId);
	self:run(connection);
end;

function MixFeederChangeFeedingsPerDay:run(connection)
	self.object:changeFeedingsPerDay(self.feedingsPerDay, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederChangeFeedingsPerDay:new(self.object, self.feedingsPerDay), nil, connection, self.object);
	end;  
end;

function MixFeederChangeFeedingsPerDay.sendEvent(object, feedingsPerDay, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederChangeFeedingsPerDay:new(object, feedingsPerDay), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederChangeFeedingsPerDay:new(object, feedingsPerDay));
		end;
	end;
end;
