
MixFeederBuyedFillType = {};
MixFeederBuyedFillType_mt = Class(MixFeederBuyedFillType, Event);
InitEventClass(MixFeederBuyedFillType, "MixFeederBuyedFillType");

function MixFeederBuyedFillType:emptyNew()
	local self = Event:new(MixFeederBuyedFillType_mt);
	self.className="MixFeederBuyedFillType";
	return self;
end;

function MixFeederBuyedFillType:new(object, fillType, fillLevel)
	local self = MixFeederBuyedFillType:emptyNew();
	self.object = object;
	self.fillType = fillType;
	self.fillLevel = fillLevel;
	return self;
end;

function MixFeederBuyedFillType:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.fillType);
	streamWriteInt32(streamId, self.fillLevel);
end;

function MixFeederBuyedFillType:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.fillType  = streamReadString(streamId);
	self.fillLevel = streamReadInt32(streamId);
	self:run(connection);
end;

function MixFeederBuyedFillType:run(connection)
	self.object:buyedFillType(self.fillType, self.fillLevel, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederBuyedFillType:new(self.object, self.fillType, self.fillLevel), nil, connection, self.object);
	end;  
end;

function MixFeederBuyedFillType.sendEvent(object, fillType, fillLevel, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederBuyedFillType:new(object, fillType, fillLevel), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederBuyedFillType:new(object, fillType, fillLevel));
		end;
	end;
end;
