hydraulics = {};

function hydraulics.prerequisitesPresent(specializations)
    return true;
end;

function hydraulics:load(xmlFile)
	self.hydraulics = {};
	local i = 0;
	while true do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic(%d)", i);
		if not hasXMLProperty(xmlFile, hydraulicName) then
			break;
		end;
		
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		local punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		local translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		local fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"), "0 1 0"));
		local upVectors = {xUp, yUp, zUp};
		local scale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#scale"), false);
		
		local ax, ay, az = {};
		if punch ~= nil then
			ax, ay, az = getWorldTranslation(punch);
		else
			ax, ay, az = getWorldTranslation(node);
		end;
		
		local punchDistance = {};
		if translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(translationPunch);
			punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		
		if node ~= nil then
			table.insert(self.hydraulics, {node=node, punch=punch, translationPunch=translationPunch, fixPoint=fixPoint, upVectors=upVectors, punchDistance=punchDistance, scale=scale});
		end;
		i = i + 1;
	end;
	
	self.updateHydraulicsAlways = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hydraulics#updateAlways"), false);
	self.setHydraulicTime = 30;
end;

function hydraulics:update(dt)
	if self:getIsActive() then
		self.setHydraulicTime = 30;
	end;

	if self.setHydraulicTime > 0 or self.updateHydraulicsAlways then
		for _,hydraulic in pairs(self.hydraulics) do 
			if hydraulic.fixPoint ~= nil then
				local ax, ay, az = getWorldTranslation(hydraulic.node);
				local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
				local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
				local xUp, yUp, zUp = unpack(hydraulic.upVectors);
				setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
				if hydraulic.punch ~= nil then
					local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
					setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
				end;
			end;
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
end;

function hydraulics:delete()
end;

function hydraulics:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hydraulics:keyEvent(unicode, sym, modifier, isDown)
end;

function hydraulics:updateTick(dt)
end;

function hydraulics:draw()
end;