SetTraceurDroitEvent = {};
SetTraceurDroitEvent_mt = Class(SetTraceurDroitEvent, Event);

InitEventClass(SetTraceurDroitEvent, "SetTraceurDroitEvent");

function SetTraceurDroitEvent:emptyNew()
    local self = Event:new(SetTraceurDroitEvent_mt);
    self.className="SetTraceurDroitEvent";
    return self;
end;

function SetTraceurDroitEvent:new(vehicle, traceurDroit)
    local self = SetTraceurDroitEvent:emptyNew()
    self.vehicle = vehicle;
	self.traceurDroit = traceurDroit;
    return self;
end;

function SetTraceurDroitEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.traceurDroit = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTraceurDroitEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.traceurDroit);
end;

function SetTraceurDroitEvent:run(connection)   
	self.vehicle:setTraceurDroit(self.traceurDroit, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTraceurDroitEvent:new(vehicle, self.traceurDroit), nil, connection, self.vehicle);
    end;
end;

function SetTraceurDroitEvent.sendEvent(vehicle, traceurDroit, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTraceurDroitEvent:new(vehicle, traceurDroit), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTraceurDroitEvent:new(vehicle, traceurDroit));
		end;
	end;
end;