SetEmptyEvent = {};
SetEmptyEvent_mt = Class(SetEmptyEvent, Event);

InitEventClass(SetEmptyEvent, "SetEmptyEvent");

function SetEmptyEvent:emptyNew()
    local self = Event:new(SetEmptyEvent_mt);
    self.className="SetEmptyEvent";
    return self;
end;

function SetEmptyEvent:new(vehicle, empty)
    local self = SetEmptyEvent:emptyNew()
    self.vehicle = vehicle;
	self.empty = empty;
    return self;
end;

function SetEmptyEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.empty = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetEmptyEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.empty);
end;

function SetEmptyEvent:run(connection)   
	self.vehicle:SetEmptyEvent(self.empty, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetEmptyEvent:new(vehicle, self.empty), nil, connection, self.vehicle);
    end;
end;

function SetEmptyEvent.sendEvent(vehicle, empty, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetEmptyEvent:new(vehicle, empty), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetEmptyEvent:new(vehicle, empty));
		end;
	end;
end;