DF_2 = {};

function DF_2.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function DF_2:load(xmlFile)
	self.setEmpty = SpecializationUtil.callSpecializationsFunction("setEmpty");		
	self.empty = false;
	self.planeOpen = false;	
	self.elastique = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.elastique#index"));
	
	self.pieds = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pieds#index"));
	-- Speed rotating parts --
	self.speedRotatingParts = {};
	local i = 0;
	while true do
	    local baseName = string.format("vehicle.speedRotatingParts.speedRotatingPart(%d)", i);
		if not hasXMLProperty(xmlFile, baseName) then
			break;
		end;
		
		local index = getXMLString(xmlFile, baseName .. "#index");
		if index == nil then
			break;
		end;
		
		local node = Utils.indexToObject(self.components, index);
		if node == nil then
		    break;
		end;
		
		local entry = {};
		entry.node = node;
		
		entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName .. "#rotationSpeedScale");
		if entry.rotationSpeedScale == nil then
		    entry.rotationSpeedScale = 1.0 / Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#radius"), 1);
		end;
		
		entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
		entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
		entry.rotateOnGroundContact = Utils.getNoNil(getXMLBool(xmlFile, baseName .. "#rotateOnGroundContact"), false);
		
		table.insert(self.speedRotatingParts, entry);
		
		i = i + 1;
	end;	
end;

function DF_2:delete()
end;

function DF_2:readStream(streamId, connection)
   self:setEmpty(streamReadBool(streamId), true);
   
end;

function DF_2:writeStream(streamId, connection)
	streamWriteBool(streamId, self.empty);
end;

function DF_2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DF_2:keyEvent(unicode, sym, modifier, isDown)
end;

function DF_2:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.EMPTY) then
			self:setEmpty(not self.empty);
		end;
		if InputBinding.hasEvent(InputBinding.DF2_BACHE) then
			if self.planeOpen then
				self:setAnimationTime(1, self.animationParts[1].offSet, false);
				setVisibility(self.elastique, true);				
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration, false);
				setVisibility(self.elastique, false);
			end;
		end;
	end;
	self.planeOpen = self.animationParts[1].clipEndTime and self.animationParts[1].inputDone;
	self.allowFillFromAir = self.planeOpen;	
end;

function DF_2:updateTick(dt)
	if self:getIsActive() then
		if self.movingDirection ~= 0 and self:isLowered(false) then
			for k,v in pairs(self.speedRotatingParts) do
				if self.foldAnimTime == nil or (self.foldAnimTime <= v.foldMaxLimit and self.foldAnimTime >= v.foldMinLimit) then
					rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
				end;
			end;
		end;
	end;
end;

function DF_2:draw()	
	if self.planeOpen then
		g_currentMission:addHelpButtonText(g_i18n:getText("DF2_1"), InputBinding.DF2_BACHE);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("DF2_2"), InputBinding.DF2_BACHE);
	end;
	g_currentMission:addHelpButtonText(g_i18n:getText("EMPTY"), InputBinding.EMPTY);
	if self.isClient then
		if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
		local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
			if fruitType ~= nil then
			g_currentMission:setFruitOverlayFruitType(fruitType);
			end;
		end;
	end;
end;

function DF_2:onAttach(attacherVehicle)
	setVisibility(self.pieds, false);
end;

function DF_2:onDetach()
	setVisibility(self.pieds, true);
end;

function DF_2:setEmpty(empty, noEventSend)
	SetEmptyEvent.sendEvent(self, empty, noEventSend);
	if empty then 
		if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and self.fillLevel > 0 then
			self.fillLevel = 0;
			--self.currentFillType = Fillable.FILLTYPE_UNKNOWN;
			self:setFillLevel(self.fillLevel, self.currentFillType);
		end;
		self.empty = false;
	end;
end;
	